/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.importer.impl.customfields;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.impl.VersionCFType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.plugins.importer.imports.importer.impl.customfields.CFValueHandler;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import javax.annotation.Nullable;

public class CFValueHandlerVersion
implements CFValueHandler {
    private final VersionManager versionManager;

    public CFValueHandlerVersion(VersionManager versionManager) {
        this.versionManager = versionManager;
    }

    @Override
    public boolean canHandleCustomField(CustomField customfield, Issue issue) {
        return customfield.getCustomFieldType() instanceof VersionCFType;
    }

    @Override
    public Optional<Object> prepareCustomFieldValue(CustomField customField, final Issue issue, Collection<Object> values) {
        Collection versionCollection = Collections2.transform(CFValueHandlerVersion.toStringCollection(values), (Function)new Function<String, String>(){

            public String apply(@Nullable String input) {
                Version version = CFValueHandlerVersion.this.versionManager.getVersion(issue.getProjectObject().getId(), input);
                return version != null ? version.getId().toString() : null;
            }
        });
        ImmutableSet uniqueVersions = ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)versionCollection, (Predicate)Predicates.notNull()));
        if (uniqueVersions.size() <= 0) {
            return Optional.absent();
        }
        return Optional.of((Object)uniqueVersions);
    }

    @Override
    public Optional<Object> exportValue(CustomField customField, Issue issue) {
        Object value = customField.getValue(issue);
        if (value instanceof Version) {
            Version version = (Version)value;
            return Optional.of((Object)version.getName());
        }
        if (value instanceof Collection) {
            Collection versions = (Collection)value;
            Iterable versionByName = Iterables.transform((Iterable)versions, (Function)new Function<Version, String>(){

                public String apply(Version input) {
                    return input.getName();
                }
            });
            return Optional.of((Object)ImmutableList.copyOf((Iterable)versionByName));
        }
        return Optional.absent();
    }

    private static Collection<String> toStringCollection(Collection<Object> collection) {
        return Collections2.transform(collection, (Function)new Function<Object, String>(){

            public String apply(@Nullable Object input) {
                return input != null ? input.toString() : "";
            }
        });
    }
}

