/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.importer.impl.customfields;

import com.atlassian.fugue.Option;
import com.atlassian.fugue.Options;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.plugins.importer.appbridge.software.JimJiraSoftwareAccessor;
import com.atlassian.jira.plugins.importer.external.beans.ExternalHistoryItem;
import com.atlassian.jira.plugins.importer.imports.importer.impl.AbstractHistoryItemValueMapper;
import com.atlassian.jira.plugins.importer.imports.importer.impl.customfields.CFValueHandler;
import com.atlassian.jira.project.Project;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CFValueHandlerSprint
extends AbstractHistoryItemValueMapper
implements CFValueHandler {
    public static final String SPRINT_FIELD = "Sprint";
    private static final Logger log = LoggerFactory.getLogger(CFValueHandlerSprint.class);
    private final JimJiraSoftwareAccessor jimJiraSoftwareAccessor;

    @Autowired
    public CFValueHandlerSprint(JimJiraSoftwareAccessor jimJiraSoftwareAccessor) {
        this.jimJiraSoftwareAccessor = jimJiraSoftwareAccessor;
    }

    @Override
    public boolean canHandleCustomField(CustomField customfield, Issue issue) {
        CustomFieldType customFieldType = customfield.getCustomFieldType();
        String cfKey = customFieldType != null ? customFieldType.getKey() : "";
        return "com.pyxis.greenhopper.jira:gh-sprint".equals(cfKey);
    }

    @Override
    public Optional<Object> prepareCustomFieldValue(CustomField customField, Issue issue, Collection<Object> values) {
        HashSet sprintIds = Sets.newHashSet();
        for (Object value : values) {
            if (value instanceof Map && this.jimJiraSoftwareAccessor.isGreenHopperInstalledAndEnabled()) {
                Option<Long> sprintId = this.tryToMapSprint((Map)value, issue);
                if (!sprintId.isDefined()) continue;
                sprintIds.add(((Long)sprintId.get()).toString());
                continue;
            }
            if (value == null) continue;
            sprintIds.add(value.toString());
        }
        return Optional.of((Object)sprintIds);
    }

    private Option<Long> tryToMapSprint(Map map, Issue issue) {
        DateTime completeDate = this.toDateTime(this.getSafely(map, "completeDate", Object.class));
        DateTime startDate = this.toDateTime(this.getSafely(map, "startDate", Object.class));
        DateTime endDate = this.toDateTime(this.getSafely(map, "endDate", Object.class));
        String name = this.getSafely(map, "name", String.class);
        String state = this.getSafely(map, "state", String.class);
        Number rapidViewId = this.getSafely(map, "rapidViewId", Number.class);
        Long rapidView = rapidViewId != null ? Long.valueOf(rapidViewId.longValue()) : null;
        return this.jimJiraSoftwareAccessor.reuseOrCreateSprint(completeDate, startDate, endDate, name, state, rapidView, issue.getProjectObject());
    }

    private <T> T getSafely(Map map, String key, Class<T> type) {
        Object value = map.get(key);
        if (value != null && type.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        return null;
    }

    private DateTime toDateTime(Object dateOrPeriod) {
        if (dateOrPeriod == null) {
            return null;
        }
        if (dateOrPeriod instanceof String) {
            try {
                Period period = Period.parse((String)((String)dateOrPeriod));
                return DateTime.now().plus((ReadablePeriod)period);
            }
            catch (IllegalArgumentException e) {
                log.debug("Specified value [{}] is not a period", dateOrPeriod);
            }
        }
        try {
            return new DateTime(dateOrPeriod);
        }
        catch (IllegalArgumentException e) {
            log.debug("Specified value [{}] cannot be read as date", dateOrPeriod);
            return null;
        }
    }

    @Override
    public Optional<Object> exportValue(CustomField customField, Issue issue) {
        return Optional.fromNullable((Object)customField.getValue(issue));
    }

    @Override
    public boolean canHandleHistoryItem(ExternalHistoryItem historyItem, Issue issue) {
        return "custom".equals(historyItem.getFieldType()) && SPRINT_FIELD.equals(historyItem.getField());
    }

    @Override
    protected String mapValue(String textValue, Issue issue) {
        Iterable split = Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)textValue);
        final Project project = issue.getProjectObject();
        Iterable sprintIDs = Iterables.transform((Iterable)split, (Function)new Function<String, Option<Long>>(){

            public Option<Long> apply(@Nullable String sprintName) {
                Option<Long> sprintId = CFValueHandlerSprint.this.jimJiraSoftwareAccessor.getSprintIdByName(sprintName, project);
                if (sprintId.isEmpty()) {
                    log.info("Couldn't find sprint with name '{}' inside project with key {}", (Object)sprintName, (Object)project.getKey());
                }
                return sprintId;
            }
        });
        return Joiner.on((String)", ").join(Options.flatten((Iterable)sprintIDs));
    }
}

