/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.importer.impl.customfields;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugins.importer.appbridge.software.JimJiraSoftwareAccessor;
import com.atlassian.jira.plugins.importer.imports.importer.impl.customfields.CFValueHandler;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.Query;
import com.google.common.base.Optional;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public class CFValueHandlerEpicLink
implements CFValueHandler {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final CustomFieldManager customFieldManager;
    private final SearchProvider searchProvider;
    private final JimJiraSoftwareAccessor jimJiraSoftwareAccessor;
    private volatile Long epicNameFieldId = null;

    public CFValueHandlerEpicLink(JiraAuthenticationContext jiraAuthenticationContext, CustomFieldManager customFieldManager, SearchProvider searchProvider, JimJiraSoftwareAccessor jimJiraSoftwareAccessor) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.customFieldManager = customFieldManager;
        this.searchProvider = searchProvider;
        this.jimJiraSoftwareAccessor = jimJiraSoftwareAccessor;
    }

    @Override
    public boolean canHandleCustomField(CustomField customfield, Issue issue) {
        return this.checkGreenHopper() && "com.pyxis.greenhopper.jira:gh-epic-link".equals(customfield.getCustomFieldType().getKey());
    }

    @Override
    public Optional<Object> prepareCustomFieldValue(CustomField customField, Issue issue, Collection<Object> values) {
        String epicNameOrKey = this.getEpicNameOrKey(values);
        if (StringUtils.isBlank((CharSequence)epicNameOrKey)) {
            return Optional.absent();
        }
        Issue result = this.findSingleIssueOrNull(this.byEpicIssueKey(epicNameOrKey));
        if (result != null) {
            return Optional.of((Object)result.getKey());
        }
        result = this.findSingleIssueOrNull(this.byEpicNameAndProject(epicNameOrKey, issue.getProjectObject()));
        if (result != null) {
            return Optional.of((Object)result.getKey());
        }
        result = this.findSingleIssueOrNull(this.byEpicName(epicNameOrKey));
        if (result != null) {
            return Optional.of((Object)result.getKey());
        }
        return Optional.absent();
    }

    @Override
    public Optional<Object> exportValue(CustomField customField, Issue issue) {
        Object value = customField.getValue(issue);
        if (value instanceof Issue) {
            return Optional.of((Object)((Issue)value).getKey());
        }
        return value != null ? Optional.of((Object)value.toString()) : Optional.absent();
    }

    private Query byEpicIssueKey(String issueKey) {
        return JqlQueryBuilder.newBuilder().where().issue(new String[]{issueKey}).buildQuery();
    }

    private Query byEpicName(String epicName) {
        return this.byEpicNameAndProject(epicName, null);
    }

    private String getEpicNameOrKey(Collection<Object> values) {
        return values.isEmpty() ? null : values.iterator().next().toString();
    }

    private Query byEpicNameAndProject(String epicName, Project project) {
        JqlClauseBuilder result = JqlQueryBuilder.newBuilder().where().field("cf[" + this.epicNameFieldId + "]").eq(epicName);
        if (project != null) {
            result = result.and().project(new Long[]{project.getId()});
        }
        return result.buildQuery();
    }

    private Issue findSingleIssueOrNull(Query query) {
        if (query == null) {
            return null;
        }
        try {
            SearchResults result = this.searchProvider.search(query, this.jiraAuthenticationContext.getUser(), new PagerFilter(2));
            return result.getTotal() == 1 ? (Issue)result.getIssues().get(0) : null;
        }
        catch (SearchException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean checkGreenHopper() {
        if (this.jimJiraSoftwareAccessor.isGreenHopperInstalledAndEnabled() && (this.epicNameFieldId == null || !this.isEpicNameCF(this.customFieldManager.getCustomFieldObject(this.epicNameFieldId)))) {
            this.epicNameFieldId = null;
            for (CustomField customField : this.customFieldManager.getCustomFieldObjects()) {
                if (!this.isEpicNameCF(customField)) continue;
                this.epicNameFieldId = customField.getIdAsLong();
                break;
            }
        }
        return this.epicNameFieldId != null;
    }

    private boolean isEpicNameCF(CustomField customField) {
        return customField != null && "com.pyxis.greenhopper.jira:gh-epic-label".equals(customField.getCustomFieldType().getKey());
    }
}

