/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.importer.impl;

import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class FileImportLogger
implements ImportLogger {
    private final Logger logger;
    private final File output;

    public FileImportLogger(File output) {
        this.output = output;
        this.logger = Logger.getLogger((String)(this.getClass() + Thread.currentThread().toString()));
        this.logger.setLevel(Level.ALL);
        try {
            FileAppender ap = new FileAppender((Layout)new PatternLayout("%d{ISO8601} %p - %m%n"), output.getAbsolutePath());
            this.logger.removeAllAppenders();
            this.logger.addAppender((Appender)ap);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void log(String fmt, Object ... args) {
        this.logger.info((Object)(args.length == 0 ? fmt : String.format(fmt, args)));
    }

    @Override
    public void fail(@Nullable Throwable e, String fmt, Object ... args) {
        this.logger.error((Object)(args.length == 0 ? fmt : String.format(fmt, args)), e);
    }

    @Override
    public void warn(@Nullable Throwable e, String fmt, Object ... args) {
        this.logger.warn((Object)(args.length == 0 ? fmt : String.format(fmt, args)), e);
    }

    @Override
    public void warn(String fmt, Object ... args) {
        this.warn(null, fmt, args);
    }

    @Override
    public InputStream getImportLog() {
        try {
            return new FileInputStream(this.output);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void beginImportSection(String s) {
        this.banner("Importing: %s", s);
        this.log("Only new items will be imported", new Object[0]);
    }

    private void banner(String fmt, Object ... args) {
        this.logger.info((Object)StringUtils.repeat((String)"-", (int)30));
        this.logger.info((Object)String.format(fmt, args));
        this.logger.info((Object)StringUtils.repeat((String)"-", (int)30));
    }

    @Override
    public void endImportSection(String s) {
        this.banner("Finished Importing : %s", s);
    }

    @Override
    public void skip(String s) {
        this.log("Skipped importing of %s", s);
    }
}

