/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.importer;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.plugins.importer.imports.importer.ImportStats;
import com.atlassian.jira.util.I18nHelper;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.time.StopWatch;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ImportStageStats {
    @XmlTransient
    private final DateUtils dateUtils;
    @XmlTransient
    private final I18nHelper i18nHelper;
    @XmlTransient
    private final StopWatch timer = new StopWatch();
    private long itemsToBeImported;
    private int warnings = 0;
    private int failures = 0;
    private int itemsImported = 0;
    private int itemsCreated = 0;
    private int itemsUpdated = 0;
    private int itemsCreatedWithWarnings = 0;
    private ImportStats.State state;

    public ImportStageStats(DateUtils dateUtils, I18nHelper i18nHelper) {
        this.dateUtils = dateUtils;
        this.i18nHelper = i18nHelper;
    }

    public StopWatch getTimer() {
        return this.timer;
    }

    @XmlElement
    public String getImportRate() {
        int v = (int)(this.getIssuesImportedPerMilliSeconds() * 60000.0);
        return v + " " + this.i18nHelper.getText("jira-importer-plugin.external.logs.issuesperminute.abbrv");
    }

    private double getIssuesImportedPerMilliSeconds() {
        return this.getTotalImported() / (double)this.getTimer().getTime();
    }

    @XmlElement
    public String getEstimateRemaining() {
        if (this.getTotalImported() > 10.0) {
            long issuesRemaining = this.itemsToBeImported - (long)this.itemsImported;
            double secondsRemaining = (double)issuesRemaining / this.getIssuesImportedPerMilliSeconds() / 1000.0;
            String formattedDate = this.getFormattedDate((long)(secondsRemaining *= 1.4));
            return this.i18nHelper.getText("jira-importer-plugin.external.logs.remaining", formattedDate);
        }
        return "";
    }

    private double getTotalImported() {
        return this.itemsImported;
    }

    private String getFormattedDate(long secs) {
        if (secs < 60L) {
            return this.i18nHelper.getText("core.dateutils.minute.less.than");
        }
        return this.dateUtils.formatDurationPretty(secs);
    }

    public int incrementFailures() {
        return this.failures++;
    }

    public int incrementWarnings() {
        return this.warnings++;
    }

    public int incrementProgress() {
        return this.itemsImported++;
    }

    public int incrementCreated() {
        return this.itemsCreated++;
    }

    public int incrementUpdated() {
        return this.itemsUpdated++;
    }

    public int incrementCreatedWithWarnings() {
        return this.itemsCreatedWithWarnings++;
    }

    public void start() {
        this.timer.reset();
        this.timer.start();
        this.state = ImportStats.State.RUNNING;
    }

    public void stop() {
        this.timer.stop();
        this.state = this.warnings > 0 || this.failures > 0 ? ImportStats.State.ERROR : ImportStats.State.SUCCESS;
    }

    public void setItemsToBeImported(long toBeImported) {
        this.itemsToBeImported = toBeImported;
    }

    public long getItemsToBeImported() {
        return this.itemsToBeImported;
    }

    public int getItemsCreated() {
        return this.itemsCreated;
    }

    public int getItemsUpdated() {
        return this.itemsUpdated;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public int getItemsImported() {
        return this.itemsImported;
    }
}

