/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.importer;

import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomField;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractConfigBean;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractConfigBean2;
import com.atlassian.jira.plugins.importer.imports.importer.ImportDataBean;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractDataBean<T extends AbstractConfigBean2>
extends ImportDataBean {
    protected final T configBean;

    protected AbstractDataBean(T configBean) {
        this.configBean = configBean;
    }

    @Override
    public Set<ExternalProject> getSelectedProjects(ImportLogger log) {
        return Sets.newHashSet((Iterable)Iterables.filter(this.getAllProjects(log), (Predicate)new Predicate<ExternalProject>(){

            public boolean apply(@Nullable ExternalProject input) {
                return input != null && ((AbstractConfigBean2)AbstractDataBean.this.configBean).isProjectSelected(input.getExternalName()) && StringUtils.isNotBlank((String)input.getKey()) && StringUtils.isNotBlank((String)input.getName());
            }
        }));
    }

    @Override
    public Collection<ExternalCustomField> getCustomFields() {
        ArrayList mappedCustomFields = Lists.newArrayList();
        for (ExternalCustomField field : ((AbstractConfigBean2)this.configBean).getCustomFields()) {
            if (((AbstractConfigBean2)this.configBean).isFieldMappedToIssueField(field.getId())) continue;
            String mapping = ((AbstractConfigBean2)this.configBean).getFieldMapping(field.getId());
            String customFieldName = StringUtils.isNotEmpty((String)mapping) ? mapping : field.getName();
            ExternalCustomField mappedCustomField = new ExternalCustomField(field.getId(), customFieldName, field.getTypeKey(), field.getSearcherKey());
            mappedCustomFields.add(mappedCustomField);
            if (field.getValueSet() == null) continue;
            Collection<String> rawValues = field.getValueSet();
            ArrayList mappedValues = Lists.newArrayList();
            if (rawValues == null) continue;
            for (String rawValue : rawValues) {
                mappedValues.add(((AbstractConfigBean2)this.configBean).getValueMappingHelper().getValueMappingForImport(field.getId(), rawValue));
            }
            mappedCustomField.setValueSet(mappedValues);
        }
        return mappedCustomFields;
    }

    @Override
    public String getReturnLinks() {
        return String.format("<div id=\"importAgain\"><a href=\"ExternalImport1.jspa\">%s</a></div>", ((AbstractConfigBean)this.configBean).getI18nHelper().getText("jira-importer-plugin.ImporterLogsPage.import.another"));
    }
}

