/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.importer;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;

public abstract class AbstractConfigBean {
    public void copyFromProperties(File config) throws Exception {
        FileInputStream inputStream = new FileInputStream(config);
        try {
            this.copyFromProperties(inputStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public abstract void copyFromProperties(InputStream var1) throws Exception;

    public abstract void copyToNewProperties(Map<String, Object> var1);

    @Nullable
    public abstract String getProjectKey(String var1);

    public abstract String getProjectName(String var1);

    @Nullable
    public abstract String getProjectLead(String var1);

    @Nullable
    public abstract String getProjectTypeKey(String var1);

    public void validateJustBeforeImport(ErrorCollection errors) {
    }

    public I18nHelper getI18nHelper() {
        return this.getJiraAuthenticationContext().getI18nHelper();
    }

    protected ProjectManager getProjectManager() {
        return ComponentAccessor.getProjectManager();
    }

    protected IssueLinkTypeManager getIssueLinkTypeManager() {
        return (IssueLinkTypeManager)ComponentAccessor.getComponent(IssueLinkTypeManager.class);
    }

    protected WorkflowSchemeManager getWorkflowSchemeManager() {
        return ComponentAccessor.getWorkflowSchemeManager();
    }

    protected JiraAuthenticationContext getJiraAuthenticationContext() {
        return ComponentAccessor.getJiraAuthenticationContext();
    }

    protected ConstantsManager getConstantsManager() {
        return ComponentAccessor.getConstantsManager();
    }

    protected FieldManager getFieldManager() {
        return ComponentAccessor.getFieldManager();
    }

    protected WorkflowManager getWorkflowManager() {
        return ComponentAccessor.getWorkflowManager();
    }

    protected ApplicationProperties getApplicationProperties() {
        return ComponentAccessor.getApplicationProperties();
    }
}

