/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.fogbugz.transformer;

import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.imports.AbstractResultSetTransformer;
import com.atlassian.jira.plugins.importer.imports.fogbugz.FogBugzConfigBean;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;

public class UserTransformer
extends AbstractResultSetTransformer<ExternalUser> {
    private final FogBugzConfigBean configBean;

    public UserTransformer(FogBugzConfigBean configBean, ImportLogger importLogger) {
        super(importLogger);
        this.configBean = configBean;
    }

    @Override
    public String getSqlQuery() {
        return "SELECT ixPerson, sFullName, sEmail FROM Person";
    }

    @Override
    public ExternalUser transform(ResultSet rs) throws SQLException {
        String fullName = rs.getString("sFullName");
        String username = this.configBean.getUsernameForFullName(fullName);
        String id = rs.getString("ixPerson");
        if (StringUtils.isBlank((String)username)) {
            this.log.warn("Username is blank and is not imported", new Object[0]);
            return null;
        }
        ExternalUser user = new ExternalUser(username, fullName, rs.getString("sEmail"));
        user.setId(id);
        return user;
    }
}

