/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.fogbugz.transformer;

import com.atlassian.fugue.Either;
import com.atlassian.jira.plugins.importer.external.MimeUtils;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.imports.fogbugz.FogBugzConfigBean;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.importer.ResultSetTransformer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class BugEventsTransformer
implements ResultSetTransformer<Either<ExternalComment, String>> {
    private final String ixBug;
    private final FogBugzConfigBean configBean;
    private final ImportLogger log;
    private final Set<ExternalUser> allUsers;

    public BugEventsTransformer(String ixBug, FogBugzConfigBean configBean, Set<ExternalUser> allUsers, ImportLogger log) {
        this.ixBug = ixBug;
        this.configBean = configBean;
        this.log = log;
        this.allUsers = allUsers;
    }

    @Override
    public String getSqlQuery() {
        if (this.configBean.isBugEventSformatPresent()) {
            return "SELECT b.s AS comment, b.dt AS date, b.fEmail, ixPerson, b.sFormat AS sformat FROM BugEvent b WHERE b.ixBug = " + this.ixBug + " ORDER BY b.dt ";
        }
        return "SELECT b.s AS comment, b.dt AS date, b.fEmail, ixPerson FROM BugEvent b WHERE b.ixBug = " + this.ixBug + " ORDER BY b.dt ";
    }

    @Override
    public Either<ExternalComment, String> transform(ResultSet rs) throws SQLException {
        String comment = rs.getString("comment");
        if (StringUtils.isNotBlank((String)comment)) {
            String body;
            if (!rs.getBoolean("fEmail")) {
                body = this.shouldEscapeHtml(rs) ? MimeUtils.removeHtmlTags(StringUtils.trimToEmpty((String)comment)) : StringUtils.trimToEmpty((String)comment);
            } else {
                try {
                    body = MimeUtils.getTextDataFromMimeMessage(comment);
                }
                catch (Exception e) {
                    this.log.warn(e, "Error decoding comment from string [%s]. Comment will be skipped", comment);
                    return null;
                }
            }
            if (rs.getRow() == 1) {
                return Either.right((Object)body);
            }
            String commenter = this.findCommenter(rs.getString("ixPerson"));
            if (commenter != null) {
                commenter = this.configBean.getUsernameForFullName(commenter);
            }
            return Either.left((Object)new ExternalComment(body, commenter, rs.getTimestamp("date")));
        }
        return null;
    }

    private boolean shouldEscapeHtml(ResultSet rs) throws SQLException {
        if (this.configBean.isBugEventSformatPresent()) {
            return StringUtils.equalsIgnoreCase((String)"html", (String)rs.getString("sFormat"));
        }
        return true;
    }

    private String findCommenter(String id) {
        for (ExternalUser user : this.allUsers) {
            if (!user.getId().equals(id)) continue;
            return user.getFullname();
        }
        return null;
    }
}

