/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.fogbugz.transformer;

import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.imports.AbstractAttachmentTransformer;
import com.atlassian.jira.plugins.importer.imports.fogbugz.FogBugzConfigBean;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class AttachmentTransformerVer7OrOlder
extends AbstractAttachmentTransformer {
    private final FogBugzConfigBean configBean;
    protected final String ixBug;

    public AttachmentTransformerVer7OrOlder(String ixBug, FogBugzConfigBean configBean) {
        this.ixBug = ixBug;
        this.configBean = configBean;
    }

    @Override
    public String getSqlQuery() {
        return "SELECT a.sFileName, p.sFullName, b.dt, a.sData FROM BugEvent b, Attachment a, Person p WHERE b.ixPerson = p.ixPerson  AND b.ixBugEvent = a.ixBugEvent AND b.ixBug = " + this.ixBug + " ORDER BY b.dt ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExternalAttachment transform(ResultSet rs) throws SQLException {
        ExternalAttachment externalAttachment = null;
        String fileName = rs.getString("sFileName");
        String attacher = this.configBean.getUsernameForFullName(rs.getString("sFullName"));
        if (StringUtils.isNotBlank((String)fileName)) {
            try {
                InputStream binaryStream = rs.getBinaryStream("sData");
                try {
                    File file = this.getTempFile();
                    FileOutputStream os = new FileOutputStream(file);
                    try {
                        IOUtils.copy((InputStream)binaryStream, (OutputStream)os);
                    }
                    finally {
                        IOUtils.closeQuietly((OutputStream)os);
                    }
                    externalAttachment = new ExternalAttachment(fileName, file, rs.getTimestamp("dt"));
                    externalAttachment.setAttacher(attacher);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)binaryStream);
                }
            }
            catch (IOException e) {
                throw new DataAccessException("Exception occurred dealing with attachment.", (Throwable)e);
            }
        }
        return externalAttachment;
    }
}

