/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.fogbugz.transformer;

import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.imports.AbstractTransformerFactory;
import com.atlassian.jira.plugins.importer.imports.fogbugz.FogBugzConfigBean;
import com.atlassian.jira.plugins.importer.imports.fogbugz.transformer.AttachmentTransformerVer7OrOlder;
import com.atlassian.jira.plugins.importer.imports.fogbugz.transformer.AttachmentTransformerVer8OrNewer;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.importer.ResultSetTransformer;
import com.atlassian.jira.plugins.importer.web.JdbcConnection;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class AttachmentTransformerFactory
extends AbstractTransformerFactory {
    private static final Logger log = Logger.getLogger(AttachmentTransformerFactory.class);
    private static final String TABLE_NAME = "AttachmentReference";
    final boolean hasNewTable;

    public AttachmentTransformerFactory(JdbcConnection jdbcConnection) {
        this.hasNewTable = this.checkForTableName(jdbcConnection);
    }

    public ResultSetTransformer<ExternalAttachment> create(String ixBug, FogBugzConfigBean configBean, ImportLogger importLogger) {
        if (this.hasNewTable) {
            return new AttachmentTransformerVer8OrNewer(ixBug, configBean);
        }
        return new AttachmentTransformerVer7OrOlder(ixBug, configBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForTableName(JdbcConnection jdbcConnection) {
        Connection connection = null;
        try {
            connection = jdbcConnection.getConnection();
            boolean bl = this.hasTable(connection, TABLE_NAME);
            return bl;
        }
        catch (SQLException e) {
            log.info((Object)"Assuming FogBugz is version 7.x or lower");
            log.warn((Object)"Error checking table for AttachmentReference", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    log.warn((Object)"Error closing connection", (Throwable)e);
                }
            }
        }
    }
}

