/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.fogbugz.hosted;

import com.atlassian.jira.plugins.importer.imports.config.StatusMappingUtil;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingDefinition;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingEntry;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingHelper;
import com.atlassian.jira.plugins.importer.imports.fogbugz.config.StatusValueMapper;
import com.atlassian.jira.plugins.importer.imports.fogbugz.hosted.FogBugzHostedConfigBean;
import com.atlassian.jira.plugins.importer.imports.fogbugz.hosted.FogBugzRemoteException;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

class StatusValueMappingDefinition
implements ValueMappingDefinition {
    private final ValueMappingHelper valueMappingHelper;
    private FogBugzHostedConfigBean configBean;

    public StatusValueMappingDefinition(FogBugzHostedConfigBean configBean, ValueMappingHelper valueMappingHelper) {
        this.configBean = configBean;
        this.valueMappingHelper = valueMappingHelper;
    }

    @Override
    public String getExternalFieldId() {
        return "sStatus";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public Set<String> getDistinctValues() {
        try {
            HashSet statuses = Sets.newHashSet((Iterable)Collections2.transform(this.configBean.getClient().getStatuses(), (Function)new Function<String, String>(){

                public String apply(@Nullable String input) {
                    return input != null ? StatusValueMapper.getCleanedStatus(input) : null;
                }
            }));
            statuses.add("Closed");
            return statuses;
        }
        catch (FogBugzRemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getJiraFieldId() {
        return "status";
    }

    @Override
    public Collection<ValueMappingEntry> getTargetValues() {
        return StatusMappingUtil.getTargetValues(this.configBean);
    }

    @Override
    public Collection<ValueMappingEntry> getDefaultValues() {
        return new ImmutableList.Builder().add((Object[])new ValueMappingEntry[]{new ValueMappingEntry("Active", 1), new ValueMappingEntry("Pending", 1), new ValueMappingEntry("Abandoned - No Consensus", 6), new ValueMappingEntry("Resolved", 5), new ValueMappingEntry("Approved", 5), new ValueMappingEntry("Closed", 6)}).build();
    }

    @Override
    public boolean canBeBlank() {
        return false;
    }

    @Override
    public boolean canBeImportedAsIs() {
        return false;
    }

    @Override
    public boolean canBeCustom() {
        return false;
    }

    @Override
    public boolean isMandatory() {
        return true;
    }
}

