/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.fogbugz.hosted;

import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComponent;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalLink;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.external.beans.ExternalVersion;
import com.atlassian.jira.plugins.importer.imports.AbstractProjectTransformer;
import com.atlassian.jira.plugins.importer.imports.fogbugz.hosted.CaseFactory;
import com.atlassian.jira.plugins.importer.imports.fogbugz.hosted.FogBugzHostedConfigBean;
import com.atlassian.jira.plugins.importer.imports.fogbugz.hosted.FogBugzRemoteException;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractDataBean;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.util.iterator.CachingIterator;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class FogBugzHostedDataBean
extends AbstractDataBean<FogBugzHostedConfigBean> {
    private Map<String, ExternalUser> usersByExternalId;
    private Set<ExternalUser> users;
    private CaseFactory caseFactory;

    public FogBugzHostedDataBean(FogBugzHostedConfigBean configBean) {
        super(configBean);
    }

    @Override
    public Set<ExternalUser> getRequiredUsers(Collection<ExternalProject> projects, ImportLogger importLogger) {
        return this.getAllUsers(importLogger);
    }

    Map<String, ExternalUser> getUsersById(ImportLogger log) {
        if (this.usersByExternalId == null) {
            this.usersByExternalId = Maps.newHashMap();
            for (ExternalUser user : this.getAllUsers(log)) {
                this.usersByExternalId.put(user.getId(), user);
            }
        }
        return this.usersByExternalId;
    }

    @Override
    public Set<ExternalUser> getAllUsers(ImportLogger importLogger) {
        if (this.users == null) {
            try {
                this.users = Sets.newHashSet(((FogBugzHostedConfigBean)this.configBean).getClient().getAllUsers(importLogger));
            }
            catch (FogBugzRemoteException e) {
                throw new RuntimeException(e);
            }
        }
        return this.users;
    }

    @Override
    public Set<ExternalProject> getAllProjects(ImportLogger log) {
        try {
            return Sets.newHashSet((Iterable)Iterables.transform(((FogBugzHostedConfigBean)this.configBean).getClient().getAllProjects(log), (Function)new Function<ExternalProject, ExternalProject>(){

                public ExternalProject apply(@Nullable ExternalProject input) {
                    return input != null ? AbstractProjectTransformer.map(FogBugzHostedDataBean.this.configBean, input) : null;
                }
            }));
        }
        catch (FogBugzRemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Collection<ExternalVersion> getVersions(ExternalProject externalProject, ImportLogger importLogger) {
        try {
            Collection<ExternalVersion> versions = ((FogBugzHostedConfigBean)this.configBean).getClient().getFixFors(externalProject, importLogger);
            for (ExternalVersion version : versions) {
                if (version.getReleaseDate() == null) continue;
                version.setReleased(version.getReleaseDate().isBeforeNow());
            }
            return versions;
        }
        catch (FogBugzRemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Collection<ExternalComponent> getComponents(ExternalProject externalProject, final ImportLogger importLogger) {
        try {
            return Collections2.transform(((FogBugzHostedConfigBean)this.configBean).getClient().getAreas(externalProject, importLogger), (Function)new Function<ExternalComponent, ExternalComponent>(){

                public ExternalComponent apply(ExternalComponent input) {
                    return new ExternalComponent(input.getName(), input.getId(), FogBugzHostedDataBean.this.getUsernameForId(input.getLead(), importLogger), input.getDescription());
                }
            });
        }
        catch (FogBugzRemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    String getUsernameForId(@Nullable String id, ImportLogger log) {
        if (id == null) {
            return null;
        }
        Map<String, ExternalUser> usersById = this.getUsersById(log);
        ExternalUser user = usersById.get(id);
        return user != null ? user.getName() : null;
    }

    @Override
    public Iterator<ExternalIssue> getIssuesIterator(ExternalProject externalProject, ImportLogger importLogger) {
        this.caseFactory = new CaseFactory(externalProject.getId(), importLogger, this.getUsersById(importLogger), (FogBugzHostedConfigBean)this.configBean);
        return new CachingIterator<ExternalIssue>(this.caseFactory, importLogger);
    }

    @Override
    public Collection<ExternalLink> getLinks(ImportLogger log) {
        if (this.caseFactory == null) {
            return ImmutableList.of();
        }
        return Collections2.transform(this.caseFactory.getLinks(), (Function)new Function<ExternalLink, ExternalLink>(){

            public ExternalLink apply(@Nullable ExternalLink input) {
                return input != null ? new ExternalLink(((FogBugzHostedConfigBean)FogBugzHostedDataBean.this.configBean).getLinkMapping("Parent / Subcase"), input.getSourceId(), input.getDestinationId()) : null;
            }
        });
    }

    @Override
    public long getTotalIssues(Set<ExternalProject> selectedProjects, ImportLogger log) {
        try {
            return ((FogBugzHostedConfigBean)this.configBean).getClient().getTotalCases(selectedProjects, log);
        }
        catch (FogBugzRemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getUnusedUsersGroup() {
        return ((FogBugzHostedConfigBean)this.configBean).getUnusedUsersGroup();
    }

    @Override
    public void cleanUp() {
        ((FogBugzHostedConfigBean)this.configBean).getClient().logout();
    }

    @Override
    public Collection<ExternalAttachment> getAttachmentsForIssue(ExternalIssue externalIssue, ImportLogger log) {
        return ((FogBugzHostedConfigBean)this.configBean).getClient().getAttachmentsForIssue(externalIssue, log);
    }

    @Override
    public String getIssueKeyRegex() {
        return "(?:bug|case|cases|case_id):? #?([0-9 ,]+)";
    }

    @Override
    public String getExternalSystemUrl() {
        return ((FogBugzHostedConfigBean)this.configBean).getClient().getRootUri().toString();
    }
}

