/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.fogbugz.config;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.plugins.importer.imports.AbstractResolutionValueMapper;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingEntry;
import com.atlassian.jira.plugins.importer.web.JdbcConnection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nullable;

public class ResolutionValueMapper
extends AbstractResolutionValueMapper {
    public static final String FIELD = "sStatus (Resolution)";

    public ResolutionValueMapper(JdbcConnection jdbcConnection, JiraAuthenticationContext authenticationContext, ConstantsManager constantsManager) {
        super(jdbcConnection, authenticationContext, constantsManager);
    }

    @Override
    public String getExternalFieldId() {
        return FIELD;
    }

    @Override
    @Nullable
    public String getDescription() {
        return null;
    }

    @Override
    public String getSqlQuery() {
        return "SELECT DISTINCT sStatus FROM Bug, Status WHERE Bug.ixStatus=Status.ixStatus";
    }

    @Override
    @Nullable
    public String transformResolution(String status) {
        return ResolutionValueMapper.getCleanedResolution(super.transformResolution(status));
    }

    @Nullable
    public static String getCleanedResolution(String fogBugzStatus) {
        int bs = fogBugzStatus.indexOf("(");
        int be = fogBugzStatus.indexOf(")", bs);
        return bs != -1 && be != -1 && bs < be ? fogBugzStatus.substring(bs + 1, be) : null;
    }

    @Override
    public Collection<ValueMappingEntry> getDefaultValues() {
        return new ImmutableList.Builder().add((Object[])new ValueMappingEntry[]{new ValueMappingEntry("Fixed", 1), new ValueMappingEntry("By Desing", 2), new ValueMappingEntry("Duplicate", 3), new ValueMappingEntry("Won't Fix", 2), new ValueMappingEntry("Not Reproducible", 5), new ValueMappingEntry("Postponed", 2), new ValueMappingEntry("Implemented", 1)}).build();
    }
}

