/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.fogbugz.config;

import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.plugins.importer.SQLRuntimeException;
import com.atlassian.jira.plugins.importer.imports.AbstractPriorityValueMapper;
import com.atlassian.jira.plugins.importer.imports.importer.SingleStringResultTransformer;
import com.atlassian.jira.plugins.importer.web.JdbcConnection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import java.sql.SQLException;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;

public class PriorityValueMapper
extends AbstractPriorityValueMapper {
    public static final String PRIORITY_FIELD = "sPriority";

    public PriorityValueMapper(JdbcConnection jdbcConnection, JiraAuthenticationContext authenticationContext, FieldManager fieldManager) {
        super(jdbcConnection, authenticationContext, fieldManager);
    }

    @Override
    public String getExternalFieldId() {
        return PRIORITY_FIELD;
    }

    @Override
    @Nullable
    public String getDescription() {
        return null;
    }

    public static boolean isSqlServer(JdbcConnection jdbcConnection) throws SQLException {
        return jdbcConnection.getConnection().getMetaData().getDatabaseProductName().startsWith("Microsoft");
    }

    @Override
    public Set<String> getDistinctValues() {
        try {
            if (PriorityValueMapper.isSqlServer(this.jdbcConnection)) {
                return new LinkedHashSet<String>(this.jdbcConnection.queryDb(new SingleStringResultTransformer("SELECT (CAST(ixPriority AS VARCHAR(20)) + '-' + sPriority) AS priority FROM Priority ORDER BY priority")));
            }
            return new LinkedHashSet<String>(this.jdbcConnection.queryDb(new SingleStringResultTransformer("SELECT CONCAT(ixPriority,CONCAT('-',sPriority)) AS priority FROM Priority ORDER BY priority")));
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }
}

