/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.csv.web;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.TemporaryAttachmentsMonitorLocator;
import com.atlassian.jira.issue.attachment.TemporaryAttachment;
import com.atlassian.jira.plugins.importer.analytics.WizardConfigFileUsedEvent;
import com.atlassian.jira.plugins.importer.analytics.WizardOpenedEvent;
import com.atlassian.jira.plugins.importer.extensions.ImporterController;
import com.atlassian.jira.plugins.importer.imports.csv.CsvFile;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.AbstractSetupPage;
import com.atlassian.jira.plugins.importer.web.csv.GoodCsvConfigBean;
import com.atlassian.jira.plugins.importer.web.onboarding.ImporterBean;
import com.atlassian.jira.plugins.importer.web.onboarding.ImporterKeyFormatter;
import com.atlassian.jira.plugins.importer.web.onboarding.ImportersFinderHelper;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.google.common.base.Optional;
import java.nio.charset.Charset;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class CsvSetupPage
extends AbstractSetupPage {
    public static final String CSV_FILE_INPUT_NAME = "csvFile";
    public static final String CONFIG_FILE_INPUT_NAME = "configFile";
    private static final String TAB_STRING = "\\t";
    public static final String CAC_CSV_DOC_LINK = "https://confluence.atlassian.com/display/JIRA/Importing+Data+from+CSV";
    private final TemporaryAttachmentsMonitorLocator locator;
    private final ImportersFinderHelper importersFinderHelper;
    private String delimiter = GoodCsvConfigBean.DEFAULT_DELIMITER.toString();
    private String encoding = "UTF-8";
    private String fileToConvert;
    private String nonImporter;
    private Optional<ImporterBean> importerBean = null;
    private TemporaryAttachment tempAttachment;

    public CsvSetupPage(UsageTrackingService usageTrackingService, @ComponentImport WebInterfaceManager webInterfaceManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport TemporaryAttachmentsMonitorLocator locator, @ComponentImport EventPublisher eventPublisher, ImportersFinderHelper importersFinderHelper) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor, eventPublisher);
        this.locator = locator;
        this.importersFinderHelper = importersFinderHelper;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = TAB_STRING.equals(delimiter) ? String.valueOf('\t') : (StringUtils.isNotEmpty((String)delimiter) ? delimiter : ",");
    }

    public void setFiletoconvert(String fileToConvert) {
        this.fileToConvert = fileToConvert;
    }

    public String getFiletoconvert() {
        return this.fileToConvert;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    @Nullable
    public Character getDelimiterChar() {
        if (this.delimiter != null && this.delimiter.length() >= 1) {
            return Character.valueOf(this.delimiter.charAt(0));
        }
        return null;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setNonImporter(String nonImporter) {
        this.nonImporter = nonImporter;
    }

    public boolean isFromNonExisting() {
        return this.getNonExistingImporterBean().isPresent();
    }

    public String getNonExistingImporterDocumentationLink() {
        Optional<ImporterBean> bean = this.getNonExistingImporterBean();
        if (bean.isPresent()) {
            return ((ImporterBean)bean.get()).getDocumentationLink();
        }
        return "";
    }

    public String getNonExistingImporterName() {
        Optional<ImporterBean> bean = this.getNonExistingImporterBean();
        if (bean.isPresent()) {
            return ((ImporterBean)bean.get()).getName();
        }
        return "";
    }

    public boolean isComingFromNoneOfThese() {
        return "noneOfThese".equals(this.nonImporter);
    }

    public String getCsvImporterDocumentation() {
        return CAC_CSV_DOC_LINK;
    }

    private Optional<ImporterBean> getNonExistingImporterBean() {
        if (this.importerBean == null) {
            this.importerBean = this.importersFinderHelper.getUnavailableImporterBeanByKey(this.nonImporter);
        }
        return this.importerBean;
    }

    public TemporaryAttachment getTempAttachment() {
        return this.tempAttachment;
    }

    @Override
    protected void doValidation() {
        CsvFile csvFile;
        ServiceResult validateResult;
        super.doValidation();
        if (this.isPreviousClicked()) {
            return;
        }
        if (StringUtils.isEmpty((String)this.getFiletoconvert()) || !NumberUtils.isNumber((String)this.getFiletoconvert())) {
            this.addError(CSV_FILE_INPUT_NAME, this.getText("jira-importer-plugin.csv.setup.page.file.is.empty"));
            return;
        }
        this.tempAttachment = this.locator.get(true).getById(Long.valueOf(this.getFiletoconvert()));
        if (this.tempAttachment == null) {
            this.addError(CSV_FILE_INPUT_NAME, this.getText("jira-importer-plugin.csv.setup.page.file.is.empty"));
            return;
        }
        if (StringUtils.isNotEmpty((String)this.getDelimiter()) && this.getDelimiter().length() > 1) {
            this.addError("delimiter", this.getText("jira-importer-plugin.csv.setup.page.must.be.one.character"));
        }
        if (!Charset.isSupported(this.getEncoding())) {
            this.addError("encoding", this.getText("jira-importer-plugin.csv.file.invalid.encoding"));
        }
        if (!this.invalidInput() && !(validateResult = (csvFile = new CsvFile(this.getEncoding(), this.tempAttachment.getFile(), this.getDelimiterChar())).validateCsvFile()).isValid()) {
            for (String error : validateResult.getErrorCollection().getErrorMessages()) {
                this.addErrorMessage(error);
            }
        }
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        ImporterController controller = this.getController();
        if (controller == null) {
            return "restartimporterneeded";
        }
        if (!this.isPreviousClicked() && !controller.createImportProcessBean(this)) {
            return "input";
        }
        if (this.isConfigFileAttached()) {
            this.publishConfigEvent();
        }
        return super.doExecute();
    }

    @Override
    public String doDefault() throws Exception {
        this.publishOpenedEvent();
        return super.doDefault();
    }

    private void publishOpenedEvent() {
        EventPublisher eventPublisher = (EventPublisher)ComponentAccessor.getComponent(EventPublisher.class);
        ImporterController controller = this.getController();
        if (eventPublisher == null || controller == null) {
            return;
        }
        eventPublisher.publish((Object)new WizardOpenedEvent(ImporterKeyFormatter.getImporterId(controller.getId()), ImporterKeyFormatter.getImporterId(this.nonImporter), this.isOnboarding()));
    }

    private void publishConfigEvent() {
        EventPublisher eventPublisher = (EventPublisher)ComponentAccessor.getComponent(EventPublisher.class);
        ImporterController controller = this.getController();
        if (eventPublisher == null || controller == null) {
            return;
        }
        eventPublisher.publish((Object)new WizardConfigFileUsedEvent(ImporterKeyFormatter.getImporterId(controller.getId())));
    }

    private boolean isConfigFileAttached() {
        return this.getMultipart().getFile(CONFIG_FILE_INPUT_NAME) != null;
    }

    @Override
    public String getFormTitle() {
        return this.getText("jira-importer-plugin.CsvSetupPage.form.title");
    }
}

