/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.csv.mappers;

import com.atlassian.jira.plugins.importer.external.beans.ExternalWorklog;
import com.atlassian.jira.plugins.importer.imports.csv.CsvDateParser;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalUserNameMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalWorklogMapper;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;

public class SimpleExternalWorklogMapper
implements ExternalWorklogMapper {
    public static final String DEFAULT_COMMENT = "no comment";
    private final CsvDateParser dateParser;

    public SimpleExternalWorklogMapper(CsvDateParser dateParser) {
        this.dateParser = dateParser;
    }

    @Override
    public List<ExternalWorklog> buildFromMultiMap(Multimap<String, String> bean, ExternalUserNameMapper userNameMapper, ImportLogger log) {
        Collection worklogs = bean.get((Object)"worklog");
        if (worklogs != null && !worklogs.isEmpty()) {
            ArrayList externalWorklogs = Lists.newArrayListWithCapacity((int)worklogs.size());
            for (String worklog : worklogs) {
                ExternalWorklog externalWorklog;
                if (!StringUtils.isNotEmpty((String)worklog) || (externalWorklog = this.parseWorklog(worklog, userNameMapper, log)) == null) continue;
                externalWorklogs.add(externalWorklog);
            }
            return externalWorklogs;
        }
        return null;
    }

    @Nullable
    protected ExternalWorklog parseWorklog(String token, ExternalUserNameMapper userNameMapper, ImportLogger log) {
        try {
            DateTime timePerformed;
            Object[] tokens = StringUtils.splitPreserveAllTokens((String)token, (char)';');
            int i = tokens.length;
            long timeSpent = Long.parseLong(StringUtils.strip((String)tokens[--i]));
            String author = i > 0 ? userNameMapper.extractUserName(StringUtils.stripToNull((String)tokens[--i])) : null;
            String dateString = i > 0 ? StringUtils.stripToNull((String)tokens[--i]) : null;
            DateTime dateTime = timePerformed = dateString != null ? new DateTime((Object)this.dateParser.parseDateTime(dateString)) : null;
            String comment = i == 0 ? DEFAULT_COMMENT : (i == 1 ? tokens[0] : StringUtils.join((Object[])tokens, (String)";", (int)0, (int)i));
            return new ExternalWorklog(author, comment, timePerformed, timeSpent);
        }
        catch (Exception e) {
            log.warn(e, "Exception occurred parsing worklog '%s'. It will be skipped", token);
            return null;
        }
    }
}

