/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.csv.mappers;

import com.atlassian.jira.plugins.importer.external.beans.ExternalVersion;
import com.atlassian.jira.plugins.importer.imports.csv.MappedCsvLine;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalVersionMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SimpleExternalVersionMapper
implements ExternalVersionMapper {
    private final String versionPrefix;

    public SimpleExternalVersionMapper(String versionPrefix) {
        this.versionPrefix = versionPrefix;
    }

    @Override
    public List<ExternalVersion> buildFromCsvLine(MappedCsvLine csvLine) {
        Collection versionNames = csvLine.getJiraFieldMappings().get((Object)this.versionPrefix);
        if (versionNames == null || versionNames.isEmpty()) {
            return null;
        }
        if (versionNames.contains("<<!clear!>>")) {
            return Collections.emptyList();
        }
        ArrayList<ExternalVersion> externalVersions = new ArrayList<ExternalVersion>(versionNames.size());
        for (String versionName : versionNames) {
            if (!StringUtils.isNotEmpty((String)versionName)) continue;
            ExternalVersion externalVersion = new ExternalVersion();
            externalVersion.setName(versionName);
            externalVersion.setDescription(versionName);
            externalVersions.add(externalVersion);
        }
        return externalVersions;
    }
}

