/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.csv.mappers;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.plugins.importer.external.beans.ExternalVersion;
import com.atlassian.jira.plugins.importer.imports.csv.MappedCsvLine;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalVersionMapper;
import com.atlassian.jira.plugins.importer.web.csv.CsvFieldMapping;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class SimpleCustomFieldVersionMapper
implements ExternalVersionMapper {
    private static final Set<String> versionCustomFields = ImmutableSet.of((Object)"com.atlassian.jira.plugin.system.customfieldtypes:version", (Object)"com.atlassian.jira.plugin.system.customfieldtypes:multiversion");
    private final CustomFieldManager customFieldManager;

    public SimpleCustomFieldVersionMapper(CustomFieldManager customFieldManager) {
        this.customFieldManager = customFieldManager;
    }

    @Override
    public List<ExternalVersion> buildFromCsvLine(MappedCsvLine csvLine) {
        ArrayList externalVersions = Lists.newArrayList();
        Multimap<CsvFieldMapping, String> customFieldMappings = csvLine.getCustomFieldMappings();
        for (CsvFieldMapping fieldMapping : customFieldMappings.keySet()) {
            Collection versionNames;
            CustomField customField;
            String customFieldType = fieldMapping.isExistingCustomField() ? ((customField = this.customFieldManager.getCustomFieldObject(fieldMapping.getCustomFieldId())) != null ? customField.getCustomFieldType().getKey() : null) : fieldMapping.getCustomFieldType();
            if (customFieldType == null || !versionCustomFields.contains(customFieldType) || (versionNames = customFieldMappings.get((Object)fieldMapping)).contains("<<!clear!>>")) continue;
            for (String versionName : versionNames) {
                ExternalVersion externalVersion = new ExternalVersion();
                externalVersion.setName(versionName);
                externalVersion.setDescription(versionName);
                externalVersions.add(externalVersion);
            }
        }
        return externalVersions;
    }
}

