/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.csv.mappers;

import com.atlassian.jira.plugins.importer.external.beans.ExternalComment;
import com.atlassian.jira.plugins.importer.imports.csv.CsvDateParser;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalCommentMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalUserNameMapper;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class SimpleCommentMapper
implements ExternalCommentMapper {
    private final CsvDateParser dateParser;
    private static final Pattern COMMENT_PATTERN = Pattern.compile("(?s)(?:(.+?);)?+(?:(.+?);)?+(.*)");

    public SimpleCommentMapper(CsvDateParser dateParser) {
        this.dateParser = dateParser;
    }

    @Override
    @Nullable
    public List<ExternalComment> buildFromMultiMap(Multimap<String, String> bean, ExternalUserNameMapper userNameMapper, ImportLogger log) {
        Collection commentBodies = bean.get((Object)"comment");
        if (commentBodies != null && !commentBodies.isEmpty()) {
            ArrayList externalComments = Lists.newArrayListWithCapacity((int)commentBodies.size());
            for (String commentBody : commentBodies) {
                if (!StringUtils.isNotEmpty((String)commentBody)) continue;
                externalComments.add(this.parseComment(commentBody, userNameMapper, log));
            }
            return externalComments;
        }
        return null;
    }

    protected ExternalComment parseComment(String commentBody, ExternalUserNameMapper userNameMapper, ImportLogger log) {
        String user = null;
        Date timePerformed = null;
        try {
            Matcher match = COMMENT_PATTERN.matcher(commentBody);
            if (match.matches()) {
                int groups = match.groupCount();
                if (groups > 1 && match.group(1) != null) {
                    timePerformed = this.dateParser.parseDateTime(StringUtils.strip((String)match.group(1)));
                }
                if (groups > 2 && match.group(2) != null) {
                    user = userNameMapper.extractUserName(StringUtils.strip((String)match.group(2)));
                }
                commentBody = StringUtils.strip((String)match.group(groups));
            }
        }
        catch (Exception e) {
            log.log("Comment was detected as a format Date;[Author;];Comment, however and exception occurred while parsing comment. Some values may not be set. Exception: " + e.getMessage(), new Object[0]);
        }
        return new ExternalComment(commentBody, user, timePerformed);
    }
}

