/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.csv.mappers;

import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.AbstractExternalUserMapper;
import com.atlassian.jira.plugins.importer.web.csv.CsvFieldMapping;
import com.google.common.base.Function;
import com.opensymphony.util.TextUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class FullNameUserMapper
extends AbstractExternalUserMapper {
    private String emailSuffix;

    public FullNameUserMapper(@Nonnull CsvFieldMapping fullNameField) {
        this(fullNameField, null);
    }

    public FullNameUserMapper(@Nonnull CsvFieldMapping fullNameField, @Nullable String emailSuffix) {
        super(fullNameField);
        this.emailSuffix = StringUtils.defaultString((String)emailSuffix);
    }

    @Override
    protected Function<String, ExternalUser> getMapper() {
        return new Function<String, ExternalUser>(){

            public ExternalUser apply(@Nullable String fullName) {
                String username = FullNameUserMapper.this.extractUserName(fullName);
                return StringUtils.isNotEmpty((String)username) ? new ExternalUser(username, fullName, FullNameUserMapper.this.extractEmail(fullName)) : null;
            }
        };
    }

    @Override
    public String extractUserName(String fullName) {
        return StringUtils.lowerCase((String)StringUtils.replaceChars((String)fullName, (String)" '()", (String)""));
    }

    private String extractEmail(String fullName) {
        String s = TextUtils.verifyEmail((String)fullName) ? fullName : (StringUtils.contains((String)fullName, (String)" ") ? fullName.substring(0, 1) + StringUtils.substringAfterLast((String)fullName, (String)" ") + this.emailSuffix : fullName + this.emailSuffix);
        return s.toLowerCase();
    }
}

