/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.csv.mappers;

import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.AbstractExternalUserMapper;
import com.atlassian.jira.plugins.importer.web.csv.CsvFieldMapping;
import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class FirstInitialFirstNameUserMapper
extends AbstractExternalUserMapper {
    private String emailSuffix;

    public FirstInitialFirstNameUserMapper(@Nonnull CsvFieldMapping nameField) {
        this(nameField, null);
    }

    public FirstInitialFirstNameUserMapper(@Nonnull CsvFieldMapping nameField, @Nullable String emailSuffix) {
        super(nameField);
        this.emailSuffix = StringUtils.defaultString((String)emailSuffix);
    }

    @Override
    protected Function<String, ExternalUser> getMapper() {
        return new Function<String, ExternalUser>(){

            public ExternalUser apply(@Nullable String fullName) {
                String username = FirstInitialFirstNameUserMapper.this.extractUserName(fullName);
                return StringUtils.isNotEmpty((String)username) ? new ExternalUser(username, fullName, username + FirstInitialFirstNameUserMapper.this.emailSuffix) : null;
            }
        };
    }

    @Override
    public String extractUserName(String fullName) {
        String username;
        if (StringUtils.contains((String)fullName, (String)" ")) {
            username = StringUtils.replaceChars((String)fullName, (String)"-'()", (String)"");
            username = StringUtils.substring((String)username, (int)0, (int)1) + StringUtils.substringAfter((String)username, (String)" ");
            username = StringUtils.replaceChars((String)username, (String)" ", (String)"");
        } else {
            username = fullName;
        }
        return StringUtils.lowerCase((String)username);
    }
}

