/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.csv.mappers;

import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.imports.csv.CsvDateParser;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalMapper;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;

public class ExternalAttachmentMapper
implements ExternalMapper<ExternalAttachment> {
    private final CsvDateParser csvDateParser;

    public ExternalAttachmentMapper(CsvDateParser csvDateParser) {
        this.csvDateParser = csvDateParser;
    }

    @Override
    public Iterable<ExternalAttachment> buildFromMultiMap(Multimap<String, String> bean, ImportLogger log) {
        Collection attachmentStr = bean.get((Object)"attachment");
        return Iterables.transform((Iterable)attachmentStr, (Function)new Function<String, ExternalAttachment>(){

            public ExternalAttachment apply(String input) {
                try {
                    return ExternalAttachmentMapper.this.parse(input);
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public ExternalAttachment parse(String token) throws ParseException {
        if (token.startsWith("http://") || token.startsWith("https://") || token.startsWith("file:")) {
            return this.validateURI(new ExternalAttachment(null, token, new DateTime(), null));
        }
        int i = (Integer)Collections.max(ImmutableList.of((Object)token.lastIndexOf(";http://"), (Object)token.lastIndexOf(";https://"), (Object)token.lastIndexOf(";file:")));
        if (i == -1) {
            throw new ParseException(String.format("No protocols found in token '%s'. Supported protocols are: https, http and file.", token), 0);
        }
        String uri = token.substring(i + 1);
        String[] tokens = StringUtils.splitPreserveAllTokens((String)(token = token.substring(0, i)), (String)";");
        if (tokens.length > 3) {
            throw new ParseException("too many tokens", 0);
        }
        String filename = StringUtils.trimToNull((String)tokens[tokens.length - 1]);
        String author = tokens.length >= 2 ? StringUtils.trimToNull((String)tokens[tokens.length - 2]) : null;
        String timestampStr = tokens.length >= 3 ? tokens[tokens.length - 3] : null;
        DateTime timestamp = timestampStr != null ? new DateTime((Object)this.csvDateParser.parseDateTime(timestampStr)) : null;
        ExternalAttachment result = new ExternalAttachment(filename, uri, timestamp, author);
        return this.validateURI(result);
    }

    private ExternalAttachment validateURI(ExternalAttachment externalAttachment) throws ParseException {
        try {
            new URI(externalAttachment.getUri());
            return externalAttachment;
        }
        catch (URISyntaxException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }
}

