/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.csv.mappers;

import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.MultipleSettableCustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomFieldValue;
import com.atlassian.jira.plugins.importer.imports.csv.CsvDateParser;
import com.atlassian.jira.plugins.importer.imports.csv.MappedCsvLine;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalCustomFieldValueMapper;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.web.csv.CsvFieldMapping;
import com.atlassian.jira.util.DateFieldFormat;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class DefaultExternalCustomFieldValueMapper
implements ExternalCustomFieldValueMapper {
    private final CsvDateParser dateParser;
    private final DateFieldFormat dateFormatter;
    private final DateTimeFormatter dateTimeFormatter;
    private final CustomFieldManager customFieldManager;

    public DefaultExternalCustomFieldValueMapper(CsvDateParser dateParser, DateFieldFormat dateFormatter, DateTimeFormatter dateTimeFormatter, CustomFieldManager customFieldManager) {
        this.dateParser = dateParser;
        this.dateFormatter = dateFormatter;
        this.dateTimeFormatter = dateTimeFormatter.forLoggedInUser().withStyle(DateTimeStyle.DATE_TIME_PICKER);
        this.customFieldManager = customFieldManager;
    }

    @Override
    public List<ExternalCustomFieldValue> buildFromMultiMap(MappedCsvLine csvLine, final ImportLogger log) {
        final Multimap<CsvFieldMapping, String> customFieldMappings = csvLine.getCustomFieldMappings();
        Iterable transformedValues = Iterables.transform((Iterable)customFieldMappings.keySet(), (Function)new Function<CsvFieldMapping, ExternalCustomFieldValue>(){

            public ExternalCustomFieldValue apply(CsvFieldMapping input) {
                if (input.isExistingCustomField()) {
                    CustomField customField = DefaultExternalCustomFieldValueMapper.this.customFieldManager.getCustomFieldObject(input.getCustomFieldId());
                    CustomFieldSearcher customFieldSearcherObject = customField.getCustomFieldSearcher();
                    String fieldType = customField.getCustomFieldType().getKey();
                    Object value = DefaultExternalCustomFieldValueMapper.this.prepareValue(fieldType, customFieldMappings.get((Object)input), log);
                    return new ExternalCustomFieldValue(customField.getName(), fieldType, customFieldSearcherObject != null ? customFieldSearcherObject.getDescriptor().getCompleteKey() : null, value);
                }
                Object value = DefaultExternalCustomFieldValueMapper.this.prepareValue(input.getCustomFieldType(), customFieldMappings.get((Object)input), log);
                return new ExternalCustomFieldValue(input.getCustomFieldName(), input.getCustomFieldType(), input.getCustomFieldSearcher(), value);
            }
        });
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)transformedValues, (Predicate)new Predicate<ExternalCustomFieldValue>(){

            public boolean apply(ExternalCustomFieldValue input) {
                return input.getValue() != null;
            }
        }));
    }

    private Object prepareValue(String fieldType, Collection<String> values, ImportLogger log) {
        if (values.contains("<<!clear!>>")) {
            return "<<!clear!>>";
        }
        if ("com.atlassian.jira.plugin.system.customfieldtypes:date".equals(fieldType)) {
            return this.safelyParseDate(log, values, new DateParser(){

                @Override
                public Object parse(String value) throws ParseException {
                    return DefaultExternalCustomFieldValueMapper.this.dateFormatter.format(DefaultExternalCustomFieldValueMapper.this.dateParser.parseDate(value));
                }
            });
        }
        if ("com.atlassian.jira.plugin.system.customfieldtypes:datepicker".equals(fieldType)) {
            return this.safelyParseDate(log, values, new DateParser(){

                @Override
                public Object parse(String value) throws ParseException {
                    return DefaultExternalCustomFieldValueMapper.this.dateFormatter.formatDatePicker(DefaultExternalCustomFieldValueMapper.this.dateParser.parseDate(value));
                }
            });
        }
        if ("com.atlassian.jira.plugin.system.customfieldtypes:datetime".equals(fieldType)) {
            return this.safelyParseDate(log, values, new DateParser(){

                @Override
                public Object parse(String value) throws ParseException {
                    return DefaultExternalCustomFieldValueMapper.this.dateTimeFormatter.format(DefaultExternalCustomFieldValueMapper.this.dateParser.parseDateTime(value));
                }
            });
        }
        if (this.isCustomFieldWithHierarchyOptions(fieldType)) {
            return this.prepareHierarchyOptions(values);
        }
        return values;
    }

    private Object safelyParseDate(ImportLogger log, Collection<String> values, DateParser parser) {
        String valueToParse = (String)Iterables.getFirst(values, null);
        try {
            return parser.parse(valueToParse);
        }
        catch (ParseException e) {
            log.warn("Unable to parse datetime: %s using the date format pattern: %s", valueToParse, this.dateParser.getDateFormat());
            return null;
        }
    }

    private boolean isCustomFieldWithHierarchyOptions(String customFieldType) {
        if (StringUtils.isEmpty((String)customFieldType)) {
            return false;
        }
        CustomFieldType fieldType = this.customFieldManager.getCustomFieldType(customFieldType);
        return fieldType instanceof MultipleSettableCustomFieldType;
    }

    private Object prepareHierarchyOptions(Collection<String> values) {
        if (values.size() > 1 || values.isEmpty()) {
            return values;
        }
        String value = values.iterator().next();
        ArrayList splitValues = Lists.newArrayList((Iterable)Splitter.on((String)"->").trimResults().omitEmptyStrings().split((CharSequence)value));
        HashMap hierarchyOptions = Maps.newHashMap();
        int level = 0;
        for (String splitValue : splitValues) {
            String levelString = level == 0 ? null : String.valueOf(level);
            hierarchyOptions.put(levelString, splitValue);
            ++level;
        }
        return hierarchyOptions;
    }

    private static interface DateParser {
        public Object parse(String var1) throws ParseException;
    }
}

