/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.csv;

import com.atlassian.jira.plugins.importer.web.csv.CsvFieldMapping;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;

public class MappedCsvLine {
    private final Multimap<String, String> jiraFieldMappings = ArrayListMultimap.create();
    private final Multimap<CsvFieldMapping, String> customFieldMappings = ArrayListMultimap.create();
    private final Multimap<Long, String> linkMappings = ArrayListMultimap.create();

    public Multimap<String, String> getJiraFieldMappings() {
        return this.jiraFieldMappings;
    }

    public Multimap<CsvFieldMapping, String> getCustomFieldMappings() {
        return this.customFieldMappings;
    }

    public Multimap<Long, String> getLinkMappings() {
        return this.linkMappings;
    }

    public void add(CsvFieldMapping mapping, String value) {
        if (mapping.isJiraField()) {
            this.jiraFieldMappings.put((Object)mapping.getJiraFieldName(), (Object)value);
        } else if (mapping.isLinking()) {
            this.linkMappings.put((Object)mapping.getLinkTypeId(), (Object)value);
        } else {
            this.customFieldMappings.put((Object)mapping, (Object)value);
        }
    }

    public boolean contains(CsvFieldMapping fieldMapping) {
        if (fieldMapping.isJiraField()) {
            return this.jiraFieldMappings.containsKey((Object)fieldMapping.getJiraFieldName());
        }
        if (fieldMapping.isLinking()) {
            return this.linkMappings.containsKey((Object)fieldMapping.getLinkTypeId());
        }
        return this.customFieldMappings.containsKey((Object)fieldMapping);
    }

    public Collection<String> get(CsvFieldMapping fieldMapping) {
        if (fieldMapping.isJiraField()) {
            return this.jiraFieldMappings.get((Object)fieldMapping.getJiraFieldName());
        }
        if (fieldMapping.isLinking()) {
            return this.linkMappings.get((Object)fieldMapping.getLinkTypeId());
        }
        return this.customFieldMappings.get((Object)fieldMapping);
    }

    public void replace(CsvFieldMapping fieldMapping, Iterable<String> values) {
        if (fieldMapping.isJiraField()) {
            this.jiraFieldMappings.replaceValues((Object)fieldMapping.getJiraFieldName(), values);
        } else if (fieldMapping.isLinking()) {
            this.linkMappings.replaceValues((Object)fieldMapping.getLinkTypeId(), values);
        } else {
            this.customFieldMappings.replaceValues((Object)fieldMapping, values);
        }
    }
}

