/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.csv;

import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComponent;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomFieldValue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalLink;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.external.beans.ExternalVersion;
import com.atlassian.jira.plugins.importer.external.beans.ExternalWorklog;
import com.atlassian.jira.plugins.importer.external.beans.NamedExternalObject;
import com.atlassian.jira.plugins.importer.imports.AttachmentImportException;
import com.atlassian.jira.plugins.importer.imports.AttachmentImporter;
import com.atlassian.jira.plugins.importer.imports.csv.MappedCsvLine;
import com.atlassian.jira.plugins.importer.imports.csv.MappedCsvLineHandler;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalAttachmentMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalCommentMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalComponentMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalCustomFieldValueMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalIssueMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalLabelsMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalProjectMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalUserMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalUserNameMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalVersionMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalWatchersMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalWorklogMapper;
import com.atlassian.jira.plugins.importer.imports.importer.ImportDataBean;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.web.csv.GoodCsvConfigBean;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.commons.lang.math.RandomUtils;

public class CsvDataBean
extends ImportDataBean {
    public static final String ISSUE_LINK_FIELD_PREFIX = "link-";
    protected static final String UNUSED_USERS_GROUP = "csv-import-unused-users";
    private static final String EXTERNAL_ISSUE_AUTO = "autoid-";
    private final IssueManager issueManager;
    private final AttachmentManager attachmentManager;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final ExternalComponentMapper componentMapper;
    private final ExternalCustomFieldValueMapper customFieldValueMapper;
    private final ExternalVersionMapper customFieldVersionMapper;
    private final ExternalWatchersMapper externalWatchersMapper;
    private final ExternalWorklogMapper externalWorklogMapper;
    private final GoodCsvConfigBean configBean;
    private final JiraHome jiraHome;
    private final ExternalVersionMapper affectedVersionMapper;
    private final ExternalVersionMapper fixedVersionMapper;
    private final ExternalIssueMapper issueMapper;
    private final ExternalLabelsMapper labelsMapper;
    private LinkedHashSet<ExternalProject> projectsCache;
    private Set<ExternalUser> usersCache;
    private ListMultimap<ExternalProject, ExternalVersion> versionCache;
    private ListMultimap<ExternalProject, ExternalComponent> componentCache;
    private Multimap<ExternalProject, ExternalIssue> issueCache;
    private ListMultimap<ExternalIssue, String> attachmentsCache;
    private LinkedListMultimap<ExternalIssue, String> parentIssuesCache;
    private Collection<ExternalLink> linksCache;
    private List<ExternalUserMapper> userMappers;
    private ExternalProjectMapper projectMapper;
    private ExternalCommentMapper commentMapper;

    protected CsvDataBean(GoodCsvConfigBean configBean, ExternalVersionMapper affectedVersionMapper, ExternalVersionMapper fixedVersionMapper, ExternalVersionMapper customFieldVersionMapper, List<ExternalUserMapper> userMappers, ExternalComponentMapper componentMapper, ExternalProjectMapper projectMapper, ExternalIssueMapper issueMapper, ExternalCommentMapper commentMapper, ExternalCustomFieldValueMapper customFieldValueMapper, ExternalLabelsMapper labelsMapper, ExternalWatchersMapper externalWatchersMapper, ExternalWorklogMapper externalWorklogMapper, JiraHome jiraHome, IssueManager issueManager, AttachmentManager attachmentManager, IssueLinkTypeManager issueLinkTypeManager) {
        this.configBean = configBean;
        this.customFieldVersionMapper = customFieldVersionMapper;
        this.externalWatchersMapper = externalWatchersMapper;
        this.externalWorklogMapper = externalWorklogMapper;
        this.jiraHome = jiraHome;
        this.issueManager = issueManager;
        this.attachmentManager = attachmentManager;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.affectedVersionMapper = affectedVersionMapper;
        this.fixedVersionMapper = fixedVersionMapper;
        this.userMappers = userMappers;
        this.componentMapper = componentMapper;
        this.projectMapper = projectMapper;
        this.issueMapper = issueMapper;
        this.commentMapper = commentMapper;
        this.customFieldValueMapper = customFieldValueMapper;
        this.labelsMapper = labelsMapper;
    }

    @Override
    public Set<ExternalProject> getAllProjects(ImportLogger log) {
        this.refreshCache(log);
        return Sets.newLinkedHashSet(this.projectsCache);
    }

    @Override
    public Set<ExternalProject> getSelectedProjects(ImportLogger log) {
        return this.getAllProjects(log);
    }

    private synchronized void refreshCache(ImportLogger log) {
        if (this.projectsCache == null) {
            this.clearCache();
            this.populateCache(log);
        }
    }

    private synchronized void clearCache() {
        this.projectsCache = Sets.newLinkedHashSet();
        this.usersCache = Collections.newSetFromMap(new ConcurrentHashMap());
        this.versionCache = ArrayListMultimap.create();
        this.componentCache = ArrayListMultimap.create();
        this.issueCache = Multimaps.synchronizedMultimap((Multimap)ArrayListMultimap.create());
        this.attachmentsCache = ArrayListMultimap.create();
        this.parentIssuesCache = LinkedListMultimap.create();
        this.linksCache = Lists.newArrayList();
    }

    private void mergeCaches(ExternalProject from, ExternalProject to) {
        this.versionCache.putAll((Object)to, (Iterable)this.versionCache.removeAll((Object)from));
        this.componentCache.putAll((Object)to, (Iterable)this.componentCache.removeAll((Object)from));
        this.issueCache.putAll((Object)to, (Iterable)this.issueCache.removeAll((Object)from));
        this.projectsCache.remove(from);
    }

    private synchronized void populateCache(final ImportLogger log) {
        final HashMap projectsByName = Maps.newHashMap();
        final HashMap projectsByKey = Maps.newHashMap();
        this.configBean.readWholeFile(new MappedCsvLineHandler(){

            @Override
            public void handleLink(MappedCsvLine mappedLine) throws Exception {
                List<ExternalComment> externalComments;
                for (ExternalUserMapper externalUserMapper : CsvDataBean.this.userMappers) {
                    for (ExternalUser user : externalUserMapper.buildFromMultiMap(mappedLine)) {
                        CsvDataBean.this.usersCache.add(user);
                    }
                }
                ExternalUserNameMapper userMapper = CsvDataBean.this.userMappers.isEmpty() ? ExternalUserMapper.NOOP : (ExternalUserNameMapper)CsvDataBean.this.userMappers.iterator().next();
                ExternalProject curProject = CsvDataBean.this.projectMapper.buildFromMultiMap(mappedLine.getJiraFieldMappings());
                if (curProject == null) {
                    log.warn("CSV row cannot be assosciated with any project", new Object[0]);
                    return;
                }
                ExternalProject externalProject = CsvDataBean.this.collapseProjectIfPossible(projectsByName, projectsByKey, curProject, log);
                if (externalProject == null) {
                    return;
                }
                CsvDataBean.this.projectsCache.add(externalProject);
                List<ExternalVersion> affectedVersions = CsvDataBean.this.affectedVersionMapper.buildFromCsvLine(mappedLine);
                List<ExternalVersion> fixedVersions = CsvDataBean.this.fixedVersionMapper.buildFromCsvLine(mappedLine);
                List<ExternalComponent> externalComponents = CsvDataBean.this.componentMapper.buildFromMultiMap(mappedLine.getJiraFieldMappings());
                CsvDataBean.this.versionCache.putAll((Object)externalProject, CsvDataBean.this.customFieldVersionMapper.buildFromCsvLine(mappedLine));
                ExternalIssue issue = CsvDataBean.this.issueMapper.buildFromMultiMap(mappedLine.getJiraFieldMappings(), log);
                if (affectedVersions != null) {
                    CsvDataBean.this.versionCache.putAll((Object)externalProject, affectedVersions);
                    issue.setAffectedVersions(Lists.transform(affectedVersions, (Function)NamedExternalObject.NAME_FUNCTION));
                }
                if (fixedVersions != null) {
                    issue.setFixedVersions(Lists.transform(fixedVersions, (Function)NamedExternalObject.NAME_FUNCTION));
                    CsvDataBean.this.versionCache.putAll((Object)externalProject, fixedVersions);
                }
                if (externalComponents != null) {
                    issue.setComponents(Lists.transform(externalComponents, (Function)NamedExternalObject.NAME_FUNCTION));
                    CsvDataBean.this.componentCache.putAll((Object)externalProject, externalComponents);
                }
                if ((externalComments = CsvDataBean.this.commentMapper.buildFromMultiMap(mappedLine.getJiraFieldMappings(), userMapper, log)) != null && !externalComments.isEmpty()) {
                    issue.setComments(externalComments);
                }
                List<String> externalWatchers = CsvDataBean.this.externalWatchersMapper.buildFromMultiMap(mappedLine.getJiraFieldMappings(), userMapper);
                issue.setWatchers(externalWatchers);
                List<ExternalWorklog> externalWorklogs = CsvDataBean.this.externalWorklogMapper.buildFromMultiMap(mappedLine.getJiraFieldMappings(), userMapper, log);
                if (externalWorklogs != null && !externalWorklogs.isEmpty()) {
                    issue.setWorklogs(externalWorklogs);
                }
                Set<String> externalLabels = CsvDataBean.this.labelsMapper.buildFromMultiMap(mappedLine.getJiraFieldMappings());
                issue.setLabels(externalLabels);
                List<ExternalCustomFieldValue> externalCustomFieldValues = CsvDataBean.this.customFieldValueMapper.buildFromMultiMap(mappedLine, log);
                issue.setExternalCustomFieldValues(externalCustomFieldValues);
                CsvDataBean.this.issueCache.put((Object)externalProject, (Object)issue);
                CsvDataBean.this.attachmentsCache.putAll((Object)issue, (Iterable)mappedLine.getJiraFieldMappings().get((Object)"attachment"));
                if (issue.getExternalId() == null) {
                    issue.setExternalId(CsvDataBean.EXTERNAL_ISSUE_AUTO + RandomUtils.nextLong());
                    issue.setAutoExternalId(true);
                }
                CsvDataBean.this.parentIssuesCache.putAll((Object)issue, (Iterable)mappedLine.getJiraFieldMappings().get((Object)"subtask-parent-id"));
                CsvDataBean.this.handleLinking(issue, mappedLine);
            }
        });
    }

    private void handleLinking(final ExternalIssue issue, MappedCsvLine csvLine) {
        Multimap<Long, String> linkMappings = csvLine.getLinkMappings();
        Iterable links = Iterables.transform((Iterable)linkMappings.entries(), (Function)new Function<Map.Entry<Long, String>, ExternalLink>(){

            public ExternalLink apply(Map.Entry<Long, String> input) {
                IssueLinkType issueLinkType = CsvDataBean.this.issueLinkTypeManager.getIssueLinkType(input.getKey());
                return new ExternalLink(issueLinkType.getName(), issue.getExternalId(), input.getValue());
            }
        });
        this.linksCache.addAll(Lists.newArrayList((Iterable)links));
    }

    @Nullable
    private ExternalProject collapseProjectIfPossible(Map<String, ExternalProject> projectsByName, Map<String, ExternalProject> projectsByKey, ExternalProject curProject, ImportLogger logger) {
        ExternalProject prevProj;
        ExternalProject externalProject = curProject;
        if (curProject.getName() != null) {
            prevProj = projectsByName.get(curProject.getName());
            if (prevProj != null && (externalProject = this.chooseProject(prevProj, curProject, prevProj.getKey(), curProject.getKey())) == null) {
                logger.warn("Two projects have the same name '%s' but different key '%s' and '%s'. This issue will be skipped", curProject.getName(), prevProj.getKey(), curProject.getKey());
                return null;
            }
            projectsByName.put(externalProject.getName(), externalProject);
        }
        if (curProject.getKey() != null) {
            prevProj = projectsByKey.get(curProject.getKey());
            if (prevProj != null && (externalProject = this.chooseProject(prevProj, externalProject, prevProj.getName(), externalProject.getName())) == null) {
                logger.warn("Two projects have the same key '%s' but different name '%s' and '%s'. This issue will be skipped", curProject.getKey(), prevProj.getName(), curProject.getName());
                return null;
            }
            projectsByKey.put(externalProject.getKey(), externalProject);
        }
        return externalProject;
    }

    private ExternalProject chooseProject(ExternalProject prevProject, ExternalProject curProject, String prevId, String curId) {
        if (Objects.equals(prevId, curId)) {
            return prevProject;
        }
        if (prevId != null && curId != null) {
            return null;
        }
        if (curId != null) {
            this.mergeCaches(prevProject, curProject);
            return curProject;
        }
        return prevProject;
    }

    @Override
    @Nullable
    public Collection<ExternalVersion> getVersions(ExternalProject externalProject, ImportLogger importLogger) {
        this.refreshCache(importLogger);
        List versions = this.versionCache.get((Object)externalProject);
        if (versions != null) {
            ArrayList<ExternalVersion> versionsList = new ArrayList<ExternalVersion>(versions);
            Collections.sort(versionsList);
            return versionsList;
        }
        return null;
    }

    @Override
    public Collection<ExternalComponent> getComponents(ExternalProject externalProject, ImportLogger importLogger) {
        this.refreshCache(importLogger);
        List components = this.componentCache.get((Object)externalProject);
        if (components != null) {
            return Lists.newArrayList((Iterable)components);
        }
        return Lists.newArrayList();
    }

    @Override
    public Set<ExternalUser> getRequiredUsers(Collection<ExternalProject> projects, ImportLogger importLogger) {
        return this.getAllUsers(importLogger);
    }

    @Override
    public Set<ExternalUser> getAllUsers(ImportLogger importLogger) {
        this.refreshCache(importLogger);
        return this.usersCache;
    }

    public Collection<ExternalIssue> getIssues(ExternalProject externalProject, ImportLogger importLogger) {
        this.refreshCache(importLogger);
        return this.sortIssues(this.issueCache.get((Object)externalProject));
    }

    @Override
    public Iterator<ExternalIssue> getIssuesIterator(ExternalProject externalProject, ImportLogger importLogger) {
        this.refreshCache(importLogger);
        List<ExternalIssue> issuesForProject = this.sortIssues(this.issueCache.get((Object)externalProject));
        if (issuesForProject != null) {
            return issuesForProject.iterator();
        }
        return Lists.newArrayList().iterator();
    }

    private List<ExternalIssue> sortIssues(Iterable<ExternalIssue> issues) {
        ArrayList externalIssues = Lists.newArrayList((Iterable)(issues != null ? issues : Lists.newArrayList()));
        Collections.sort(externalIssues, new Comparator<ExternalIssue>(){

            @Override
            public int compare(ExternalIssue o1, ExternalIssue o2) {
                boolean o2Epic;
                boolean o1Epic = o1 != null && o1.getIssueType() != null && "Epic".equals(o1.getIssueType());
                boolean bl = o2Epic = o2 != null && o2.getIssueType() != null && "Epic".equals(o2.getIssueType());
                if (o1Epic == o2Epic) {
                    return 0;
                }
                return o1Epic ? -1 : 1;
            }
        });
        return externalIssues;
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public synchronized Collection<ExternalAttachment> getAttachmentsForIssue(final ExternalIssue externalIssue, final ImportLogger log) {
        List attachmentUrls = this.attachmentsCache.get((Object)externalIssue);
        Collection<ExternalAttachment> attachmentsForIssue = this.getAttachmentsForIssue(externalIssue, attachmentUrls, log);
        if (!this.doesIssueExists(externalIssue)) {
            return attachmentsForIssue;
        }
        MutableIssue issue = this.issueManager.getIssueObject(externalIssue.getKey());
        List attachments = this.attachmentManager.getAttachments((Issue)issue);
        final Collection existingAttachments = Collections2.transform((Collection)attachments, (Function)new Function<Attachment, String>(){

            public String apply(Attachment input) {
                return input.getFilename();
            }
        });
        return Collections2.filter(attachmentsForIssue, (Predicate)new Predicate<ExternalAttachment>(){

            public boolean apply(ExternalAttachment input) {
                boolean alreadyExists = existingAttachments.contains(input.getName());
                if (alreadyExists) {
                    log.log("Attachment '%s' of issue '%s' already exists. Skipping", input.getName(), externalIssue.getKey());
                }
                return !alreadyExists;
            }
        });
    }

    private boolean doesIssueExists(ExternalIssue issue) {
        if (issue.getKey() == null) {
            return false;
        }
        return this.issueManager.getIssueObject(issue.getKey()) != null;
    }

    Collection<ExternalAttachment> getAttachmentsForIssue(ExternalIssue externalIssue, List<String> attachmentUrls, ImportLogger log) {
        ArrayList attachments = Lists.newArrayListWithCapacity((int)attachmentUrls.size());
        AttachmentImporter attachmentImporter = new AttachmentImporter(this.jiraHome, externalIssue);
        for (String url : attachmentUrls) {
            try {
                ExternalAttachment attachment = new ExternalAttachmentMapper(this.configBean).parse(url);
                attachment.setAttachment(attachmentImporter.importAttachmentFrom(attachment));
                attachments.add(attachment);
            }
            catch (ParseException e) {
                log.warn(e, "Cannot parse '%s' as attachment info: %s", url, e.getMessage());
            }
            catch (IOException e) {
                log.warn(e, "An exception occurred dealing with attachment '%s'.", url);
            }
            catch (AttachmentImportException e) {
                log.warn(e.getMessage(), new Object[0]);
            }
        }
        return attachments;
    }

    @Override
    public String getIssueKeyRegex() {
        return null;
    }

    @Override
    public Collection<ExternalLink> getLinks(ImportLogger log) {
        ArrayList res = Lists.newArrayList();
        for (Map.Entry entry : this.parentIssuesCache.entries()) {
            res.add(new ExternalLink("sub-task-link", ((ExternalIssue)entry.getKey()).getExternalId(), (String)entry.getValue()));
        }
        res.addAll(this.linksCache);
        return res;
    }

    @Override
    public long getTotalIssues(Set<ExternalProject> selectedProjects, ImportLogger log) {
        this.refreshCache(log);
        return this.issueCache == null ? 0L : (long)this.issueCache.values().size();
    }

    @Override
    public String getUnusedUsersGroup() {
        return UNUSED_USERS_GROUP;
    }

    @Override
    public String getReturnLinks() {
        return String.format("<div id=\"importAgain\"><a href=\"ExternalImport1.jspa\">%s</a></div>", this.configBean.getI18nHelper().getText("jira-importer-plugin.ImporterLogsPage.import.another"));
    }

    public synchronized void setUserMappers(List<ExternalUserMapper> userMappers) {
        this.userMappers = userMappers;
    }

    public synchronized void setProjectMapper(ExternalProjectMapper projectMapper) {
        this.projectMapper = projectMapper;
    }
}

