/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.csv;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.plugins.importer.imports.csv.ImportException;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalCommentMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.ExternalUserMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.FullNameUserMapper;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.TimeEstimateConverter;
import com.atlassian.jira.plugins.importer.web.csv.CsvFieldMapping;
import com.atlassian.jira.plugins.importer.web.csv.GoodCsvConfigBean;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CsvConfiguration {
    private static final Logger log = Logger.getLogger(CsvConfiguration.class);
    private static final String MAPPER_PREFIX = "settings.advanced.mapper.";
    private GoodCsvConfigBean configBean;

    public CsvConfiguration(GoodCsvConfigBean configBean) throws ConfigurationException {
        this.configBean = configBean;
    }

    public List<ExternalUserMapper> getCustomUserMappers() throws ImportException {
        ArrayList<ExternalUserMapper> mappers;
        try {
            Map<String, String> extraProps = this.configBean.getUnrecognizedProperties();
            Iterable<CsvFieldMapping> mappingsWithUsers = this.configBean.getMappingsWithUsers();
            String defaultEmail = this.configBean.getUserEmailSuffix();
            String className = extraProps.get("settings.advanced.mapper.user");
            if (StringUtils.isNotEmpty((String)className)) {
                Class mapperClass = ClassLoaderUtils.loadClass((String)className, this.getClass());
                mappers = new ArrayList();
                for (CsvFieldMapping userField : mappingsWithUsers) {
                    ExternalUserMapper mapper = (ExternalUserMapper)this.newInstance(mapperClass, userField, defaultEmail);
                    mappers.add(mapper);
                }
            } else {
                mappers = new ArrayList<ExternalUserMapper>();
                for (CsvFieldMapping userField : mappingsWithUsers) {
                    FullNameUserMapper mapper = new FullNameUserMapper(userField, defaultEmail);
                    mappers.add(mapper);
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)"Loading custom user mapper classes failed", (Throwable)e);
            throw new ImportException(e);
        }
        return mappers;
    }

    private <T> T newInstance(Class<T> clazz, CsvFieldMapping mapping, String defaultEmail) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(CsvFieldMapping.class, String.class);
            return constructor.newInstance(mapping, defaultEmail);
        }
        catch (NoSuchMethodException e) {
            log.warn((Object)e);
        }
        catch (InvocationTargetException e) {
            log.warn((Object)e);
        }
        catch (InstantiationException e) {
            log.warn((Object)e);
        }
        catch (IllegalAccessException e) {
            log.warn((Object)e);
        }
        return null;
    }

    @Nullable
    public ExternalCommentMapper getCustomCommentMapper() throws ImportException {
        ExternalCommentMapper mapper = null;
        try {
            String className = this.configBean.getUnrecognizedProperties().get("settings.advanced.mapper.comment");
            if (StringUtils.isNotEmpty((String)className)) {
                Class mapperClass = ClassLoaderUtils.loadClass((String)className, this.getClass());
                mapper = (ExternalCommentMapper)mapperClass.newInstance();
            }
        }
        catch (Exception e) {
            log.warn((Object)"Loading custom comment mapper class failed", (Throwable)e);
            throw new ImportException(e);
        }
        return mapper;
    }

    @Nullable
    public TimeEstimateConverter getCustomTimeEstimateConverter() throws ImportException {
        TimeEstimateConverter converter = null;
        try {
            String className = this.configBean.getUnrecognizedProperties().get("settings.advanced.mapper.time.estimate.converter");
            if (StringUtils.isNotEmpty((String)className)) {
                Class mapperClass = ClassLoaderUtils.loadClass((String)className, this.getClass());
                converter = (TimeEstimateConverter)mapperClass.newInstance();
            }
        }
        catch (Exception e) {
            log.warn((Object)"Loading custom time estimate converter class failed", (Throwable)e);
            throw new ImportException(e);
        }
        return converter;
    }
}

