/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.config;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingEntry;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractConfigBean2;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;

public class StatusMappingUtil {
    public static Collection<ValueMappingEntry> getTargetValues(final AbstractConfigBean2 configBean) {
        List<String> projectNames = configBean.getExternalProjectNames();
        final ProjectManager projectManager = ComponentAccessor.getProjectManager();
        final WorkflowSchemeManager workflowSchemeManager = ComponentAccessor.getWorkflowSchemeManager();
        final WorkflowManager workflowManager = ComponentAccessor.getWorkflowManager();
        Iterable selectedProjects = Iterables.filter(projectNames, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return configBean.isProjectSelected(input);
            }
        });
        Iterable workflowNames = Iterables.concat((Iterable)Iterables.transform((Iterable)selectedProjects, (Function)new Function<String, Collection<String>>(){

            public Collection<String> apply(String input) {
                Project project = projectManager.getProjectObjByKey(configBean.getProjectKey(input));
                AssignableWorkflowScheme workflowScheme = project == null ? workflowSchemeManager.getDefaultWorkflowScheme() : workflowSchemeManager.getWorkflowSchemeObj(project);
                return workflowScheme.getMappings().values();
            }
        }));
        Iterable statuses = Iterables.concat((Iterable)Iterables.transform((Iterable)ImmutableSet.copyOf((Iterable)workflowNames), (Function)new Function<String, Collection<Status>>(){

            public Collection<Status> apply(String input) {
                JiraWorkflow workflow = workflowManager.getWorkflow(input);
                return workflow.getLinkedStatusObjects();
            }
        }));
        return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)statuses, (Function)new Function<Status, ValueMappingEntry>(){

            public ValueMappingEntry apply(Status input) {
                return new ValueMappingEntry(input.getName(), input.getId());
            }
        }));
    }
}

