/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.bulkcreate.web;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.issue.TemporaryAttachmentsMonitorLocator;
import com.atlassian.jira.issue.attachment.TemporaryAttachment;
import com.atlassian.jira.plugins.importer.extensions.ImporterController;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.AbstractSetupPage;
import com.atlassian.jira.web.action.issue.TemporaryAttachmentsMonitor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.web.WebInterfaceManager;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class BulkCreateSetupPage
extends AbstractSetupPage {
    public static final String CSV_FILE_INPUT_NAME = "csvFile";
    public static final String CONFIG_FILE_INPUT_NAME = "configFile";
    private final TemporaryAttachmentsMonitorLocator locator;
    private TemporaryAttachment temporaryAttachment;
    private String filetoconvert;

    public BulkCreateSetupPage(UsageTrackingService usageTrackingService, WebInterfaceManager webInterfaceManager, PluginAccessor pluginAccessor, EventPublisher eventPublisher, TemporaryAttachmentsMonitorLocator locator) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor, eventPublisher);
        this.locator = locator;
    }

    @Override
    protected void doValidation() {
        super.doValidation();
        if (this.isPreviousClicked()) {
            return;
        }
        if (StringUtils.isEmpty((String)this.filetoconvert) || !NumberUtils.isNumber((String)this.filetoconvert)) {
            this.addError(CSV_FILE_INPUT_NAME, this.getText("File not uploaded"));
            return;
        }
        TemporaryAttachmentsMonitor attachmentsMonitor = this.locator.get(true);
        TemporaryAttachment temporaryAttachment = this.temporaryAttachment = attachmentsMonitor != null ? attachmentsMonitor.getById(Long.valueOf(this.filetoconvert)) : null;
        if (this.temporaryAttachment == null) {
            this.addError(CSV_FILE_INPUT_NAME, this.getText("File not uploaded"));
        }
    }

    @Override
    protected String doExecute() throws Exception {
        ImporterController controller = this.getController();
        if (controller == null) {
            return "restartimporterneeded";
        }
        if (!this.isPreviousClicked() && !controller.createImportProcessBean(this)) {
            return "input";
        }
        return super.doExecute();
    }

    @Override
    public String doDefault() throws Exception {
        if (!this.hasUserBulkChangePermission()) {
            return "denied";
        }
        return super.doDefault();
    }

    private boolean hasUserBulkChangePermission() {
        return this.getGlobalPermissionManager().hasPermission(33, this.getLoggedInApplicationUser());
    }

    public TemporaryAttachment getTempAttachment() {
        return this.temporaryAttachment;
    }

    public void setFiletoconvert(String filetoconvert) {
        this.filetoconvert = filetoconvert;
    }

    public boolean isConfigFileAttached() {
        return this.getMultipart().getFile(CONFIG_FILE_INPUT_NAME) != null;
    }
}

