/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.bulkcreate.web;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.plugins.importer.extensions.ImporterController2;
import com.atlassian.jira.plugins.importer.imports.csv.CsvFile;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.ImportProcessBean;
import com.atlassian.jira.plugins.importer.web.components.ProjectSelectionModel;
import com.atlassian.jira.plugins.importer.web.csv.AbstractCsvProjectMappingPage;
import com.atlassian.jira.plugins.importer.web.csv.GoodCsvConfigBean;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ParameterUtils;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import webwork.action.ActionContext;

public class BulkCreateSettingsPage
extends AbstractCsvProjectMappingPage {
    private final PermissionManager permissionManager;
    private final DateTimeFormatter dateTimeFormatter;
    private String dateImportFormat;
    private String delimiter;
    private String encoding;

    public String getEncoding() {
        return this.encoding;
    }

    public String getDelimiter() {
        if ("\t".equals(this.delimiter)) {
            return "\\t";
        }
        return this.delimiter;
    }

    public String getDateImportFormat() {
        return this.dateImportFormat;
    }

    public void setDateImportFormat(String dateImportFormat) {
        this.dateImportFormat = dateImportFormat;
    }

    public void setDelimiter(String delimiter) {
        if ("\\t".equals(delimiter)) {
            delimiter = "\t";
        }
        this.delimiter = delimiter;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public BulkCreateSettingsPage(UsageTrackingService usageTrackingService, WebInterfaceManager webInterfaceManager, PluginAccessor pluginAccessor, ProjectManager projectManager, ProjectService projectService, PermissionManager permissionManager, DateTimeFormatter dateTimeFormatter) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor, projectService, projectManager);
        this.permissionManager = permissionManager;
        this.dateTimeFormatter = dateTimeFormatter;
    }

    @Override
    public String getProjectMappingModel() {
        ProjectSelectionModel model = new ProjectSelectionModel();
        GoodCsvConfigBean configBean = this.getConfigBean();
        model.key = configBean.getProjectKey("CSV");
        model.selected = true;
        model.id = "CSV";
        try {
            return new ObjectMapper().writeValueAsString((Object)model);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<String> getAvailableEncodings() {
        return Charset.availableCharsets().keySet();
    }

    @Override
    protected Collection<Project> getApplicableProjects() {
        return this.permissionManager.getProjects(11, this.getLoggedInApplicationUser());
    }

    @Override
    public String doDefault() throws Exception {
        String result = super.doDefault();
        GoodCsvConfigBean configBean = this.getConfigBean();
        if ("input".equals(result)) {
            if (this.delimiter == null) {
                this.setDelimiter(configBean.getDelimiter().toString());
            }
            if (this.dateImportFormat == null) {
                this.dateImportFormat = StringUtils.defaultIfEmpty((String)configBean.getDateFormat(), (String)this.dateTimeFormatter.getFormatHint());
            }
            if (this.encoding == null) {
                this.encoding = configBean.getEncoding();
            }
        }
        return result;
    }

    @Override
    protected String doExecute() throws Exception {
        String result = super.doExecute();
        if (!this.invalidInput()) {
            this.getConfigBean().initFile();
        }
        return result;
    }

    private String getDelemiterRealValue() {
        return this.delimiter;
    }

    @Override
    protected void doValidation() {
        CsvFile csvFile;
        ServiceResult validateResult;
        if (this.isPreviousClicked()) {
            return;
        }
        Map actionParams = ActionContext.getParameters();
        String projectKey = ParameterUtils.getStringParam((Map)actionParams, (String)"CSV_project_key");
        Project project = this.projectManager.getProjectByCurrentKey(projectKey);
        if (project == null) {
            this.addErrorMessage(this.getText("jira-importer-plugin.bc.invalid.project"));
        }
        if (StringUtils.isNotEmpty((String)this.getDelemiterRealValue()) && this.getDelemiterRealValue().length() > 1) {
            this.addError("delimiter", this.getText("jira-importer-plugin.csv.setup.page.must.be.one.character"));
        }
        if (StringUtils.isEmpty((String)this.getDelemiterRealValue())) {
            this.addError("delimiter", this.getText("jira-importer-plugin.bc.importer.delimiter.empty"));
        }
        if (StringUtils.isEmpty((String)this.getDateImportFormat())) {
            this.addError("dateImportFormat", this.getText("jira-importer-plugin.bc.importer.date.format.empty"));
        }
        if (StringUtils.isEmpty((String)this.getEncoding()) || !Charset.isSupported(this.getEncoding())) {
            this.addError("encoding", this.getText("jira-importer-plugin.csv.file.invalid.encoding"));
        }
        try {
            new SimpleDateFormat(this.dateImportFormat);
        }
        catch (IllegalArgumentException e) {
            this.addError("dateImportFormat", this.getText("jira-importer-plugin.csv.misc.page.invalid.date.format", e.getMessage()));
        }
        GoodCsvConfigBean configBean = this.getConfigBean();
        configBean.setDateFormat(this.dateImportFormat);
        if (StringUtils.isNotEmpty((String)this.delimiter)) {
            configBean.setDelimiter(Character.valueOf(this.delimiter.charAt(0)));
        }
        configBean.setEncoding(this.encoding);
        if (project != null) {
            configBean.setPickedProject(projectKey, project.getName(), project.getLeadUserName(), null);
        }
        if (!this.invalidInput() && !(validateResult = (csvFile = new CsvFile(this.getEncoding(), configBean.getCsvFilePath(), Character.valueOf(this.getDelemiterRealValue().charAt(0)))).validateCsvFile()).isValid()) {
            for (String error : validateResult.getErrorCollection().getErrorMessages()) {
                this.addErrorMessage(error);
            }
        }
    }

    @Override
    public GoodCsvConfigBean getConfigBean() {
        ImporterController2 controller2 = this.getController2();
        if (controller2 != null) {
            ImportProcessBean processBean = controller2.getImportProcessBeanFromSession();
            return processBean != null ? (GoodCsvConfigBean)processBean.getConfigBean() : null;
        }
        return null;
    }

    @Override
    @Nullable
    public String getFormTitle() {
        return this.getText("jira-importer-plugin.bc.settings.title");
    }

    @Override
    @Nonnull
    public Iterable<String> getRequiredResources() {
        return ImmutableList.of((Object)"com.atlassian.jira.plugins.jira-importers-plugin:bulkCreateProjectMappingsPage");
    }
}

