/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.bulkcreate.engine;

import com.atlassian.core.util.DateUtils;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.IssueInputParametersImpl;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.label.LabelParser;
import com.atlassian.jira.plugins.importer.BackCompatibilityUtil;
import com.atlassian.jira.plugins.importer.analytics.ImporterFinishedEvent;
import com.atlassian.jira.plugins.importer.compatibility.CompatibilityBridgeUtils;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomFieldValue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalLink;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.imports.bulkcreate.BulkCreateAdvancedSettings;
import com.atlassian.jira.plugins.importer.imports.bulkcreate.engine.BulkCreateCustomFieldsHelper;
import com.atlassian.jira.plugins.importer.imports.bulkcreate.engine.CreatedIssueInfo;
import com.atlassian.jira.plugins.importer.imports.bulkcreate.engine.LinkImportUtils;
import com.atlassian.jira.plugins.importer.imports.importer.ImportStats;
import com.atlassian.jira.plugins.importer.imports.importer.PostImportInformations;
import com.atlassian.jira.plugins.importer.imports.importer.ValidableJiraDataImporter;
import com.atlassian.jira.plugins.importer.imports.importer.impl.AbstractDataImporter;
import com.atlassian.jira.plugins.importer.imports.importer.impl.FileImportLogger;
import com.atlassian.jira.plugins.importer.imports.importer.impl.ImporterExecutionContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.util.DateFieldFormat;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class BulkCreateDataImporter
extends AbstractDataImporter
implements ValidableJiraDataImporter,
PostImportInformations {
    private final JiraAuthenticationContext authenticationContext;
    private final ProjectManager projectManager;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final IssueService issueService;
    private final VersionManager versionManager;
    private final ConstantsManager constantsManager;
    private final ProjectComponentManager projectComponentManager;
    private final DateFieldFormat dateFieldFormat;
    private final DateTimeFormatter dateTimeFormatter;
    private final EventPublisher eventPublisher;
    private final BulkCreateCustomFieldsHelper customFieldsHelper;
    private final ApplicationProperties applicationProperties;
    private final LinkImportUtils linkImportUtils;
    private final SubTaskManager subTaskManager;
    private final BulkCreateAdvancedSettings bulkCreateAdvancedSettings;
    private final CompatibilityBridgeUtils bridgeUtils;
    private Project project;
    private ValidableFileImportLogger log;
    private PostImportInformations.ImportInfo importInfo;
    private Long epicNameCustomFieldId = null;
    private List<CreatedIssueInfo> createdIssueInfos;
    private List<ExternalIssue> subtasksCache;
    private boolean isValidationMode;
    private Collection<ExternalLink> links;

    public BulkCreateDataImporter(TaskManager taskManager, JiraAuthenticationContext authenticationContext, ProjectManager projectManager, IssueTypeSchemeManager issueTypeSchemeManager, IssueService issueService, VersionManager versionManager, ConstantsManager constantsManager, ProjectComponentManager projectComponentManager, BackCompatibilityUtil backCompatibilityUtil, DateFieldFormat dateFieldFormat, EventPublisher eventPublisher, BulkCreateCustomFieldsHelper customFieldsHelper, ApplicationProperties applicationProperties, LinkImportUtils linkImportUtils, SubTaskManager subTaskManager, BulkCreateAdvancedSettings bulkCreateAdvancedSettings, CompatibilityBridgeUtils bridgeUtils, DateTimeFormatter dateTimeFormatter) {
        super(taskManager, backCompatibilityUtil, authenticationContext);
        this.authenticationContext = authenticationContext;
        this.projectManager = projectManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.issueService = issueService;
        this.versionManager = versionManager;
        this.constantsManager = constantsManager;
        this.projectComponentManager = projectComponentManager;
        this.dateFieldFormat = dateFieldFormat;
        this.eventPublisher = eventPublisher;
        this.customFieldsHelper = customFieldsHelper;
        this.applicationProperties = applicationProperties;
        this.linkImportUtils = linkImportUtils;
        this.subTaskManager = subTaskManager;
        this.bulkCreateAdvancedSettings = bulkCreateAdvancedSettings;
        this.bridgeUtils = bridgeUtils;
        this.dateTimeFormatter = dateTimeFormatter;
    }

    @Override
    public void doValidate(ImporterExecutionContext importerExecutionContext) {
        this.isValidationMode = true;
        this.runImporterEngine();
    }

    @Override
    public void doImport(ImporterExecutionContext importerExecutionContext) {
        this.isValidationMode = false;
        this.runImporterEngine();
    }

    private void prepareImporter() {
        this.importInfo = new PostImportInformations.ImportInfo();
        this.createdIssueInfos = Lists.newArrayList();
        this.subtasksCache = Lists.newArrayList();
    }

    private void runImporterEngine() {
        try {
            this.log.log("Importer started!", new Object[0]);
            this.log.log("Engine is running in %s mode", this.isValidationMode ? "Validation-only" : "Import");
            this.prepareImporter();
            ExternalProject externalProject = this.getProject();
            this.project = this.projectManager.getProjectByCurrentKey(externalProject.getKey());
            this.log.log("All issues will be imported to project: %s (%s)", this.project.getName(), this.project.getKey());
            this.stats.beginStep(ImportStats.Stage.ISSUES);
            this.stats.setTotalItems(this.dataBean.getTotalIssues((Set<ExternalProject>)ImmutableSet.of((Object)externalProject), this.log));
            Iterator<ExternalIssue> issuesIterator = this.dataBean.getIssuesIterator(externalProject, this.log);
            this.links = this.dataBean.getLinks(this.log);
            this.doImportIssues(issuesIterator);
            this.doImportSubtasks();
            this.log.setCurrentIssue(null);
            for (ExternalLink link : this.links) {
                boolean isSuccessful = this.linkImportUtils.handleIssueLink(link, this.createdIssueInfos, this.project, this.isValidationMode, this.log);
                if (isSuccessful) continue;
                if (this.isIssuesCreatedWithExternalId(link.getSourceId())) {
                    this.log.setIssueWithWarning(link.getSourceId());
                }
                if (!this.isIssuesCreatedWithExternalId(link.getDestinationId())) continue;
                this.log.setIssueWithWarning(link.getDestinationId());
            }
        }
        catch (Throwable t) {
            this.log.fail(t, "Fatal error during import", new Object[0]);
        }
        this.importInfo.setProject(this.project);
        this.finalizeImport();
    }

    private boolean isIssuesCreatedWithExternalId(final String externalId) {
        return Iterables.any(this.createdIssueInfos, (Predicate)new Predicate<CreatedIssueInfo>(){

            public boolean apply(@Nullable CreatedIssueInfo input) {
                return externalId.equals(input.getExternalId());
            }
        });
    }

    private void doImportIssues(Iterator<ExternalIssue> issuesIterator) {
        while (issuesIterator.hasNext() && !this.shouldBeAborted()) {
            ExternalIssue ei = issuesIterator.next();
            this.log.setCurrentIssue(ei.getExternalId());
            if (this.isSubtask(ei)) {
                this.subtasksCache.add(ei);
                continue;
            }
            if (this.hasParentIdAssigned(ei)) {
                this.log.warn("Issue '%s' doesn't have Subtask Issue Type, its Parent Id mapping will be ignored.", ei.getSummary());
            }
            this.log.log("Creating issue: " + ei, new Object[0]);
            IssueInputParameters issueInputParameters = this.externalIssueToInputParams(ei);
            IssueService.CreateValidationResult validationResult = this.bridgeUtils.validateCreate(this.issueService, this.authenticationContext.getUser(), issueInputParameters);
            if (validationResult.isValid()) {
                String issueKey = null;
                if (this.isValidationMode) {
                    this.log.log("No problems found with issue '%s'", ei.getSummary());
                    this.stats.incrementCreated();
                } else {
                    issueKey = this.createIssue(ei, validationResult).getKey();
                }
                this.saveNecessaryInfo(issueInputParameters, issueKey, ei);
            } else {
                this.printErrors((ServiceResult)validationResult);
            }
            this.stats.incrementProgress();
        }
    }

    private boolean hasParentIdAssigned(final ExternalIssue ei) {
        return Iterables.any(this.links, (Predicate)new Predicate<ExternalLink>(){

            public boolean apply(@Nullable ExternalLink input) {
                return input.isSubtask() && input.getSourceId().equals(ei.getExternalId());
            }
        });
    }

    private void doImportSubtasks() {
        for (ExternalIssue ei : this.subtasksCache) {
            Long subtaskParentId;
            IssueType parentIssueType;
            this.log.setCurrentIssue(ei.getExternalId());
            if (this.shouldBeAborted()) break;
            this.log.log("Creating issue: " + ei, new Object[0]);
            IssueInputParameters issueInputParameters = this.externalIssueToInputParams(ei);
            Either<Issue, CreatedIssueInfo> subtaskParent = this.getSubtaskParentId(ei);
            if (subtaskParent == null) {
                this.log.fail(null, "Subtask '%s' doesn't have a valid Parent Id selection. Issue will not be created.", ei.getSummary());
                continue;
            }
            if (subtaskParent.isLeft()) {
                Issue issue = (Issue)subtaskParent.left().get();
                parentIssueType = issue.getIssueTypeObject();
                subtaskParentId = issue.getId();
            } else {
                parentIssueType = ((CreatedIssueInfo)subtaskParent.right().get()).getIssueType();
                subtaskParentId = -1L;
            }
            if (parentIssueType.isSubTask()) {
                this.log.fail(null, "Subtask '%s' can't be created under another Subtask. Issue will not be created.", ei.getSummary());
                continue;
            }
            IssueService.CreateValidationResult validationResult = this.bridgeUtils.validateSubTaskCreate(this.issueService, this.authenticationContext.getUser(), subtaskParentId, issueInputParameters);
            if (validationResult.isValid()) {
                String issueKey = null;
                if (this.isValidationMode) {
                    this.log.log("No problems found with issue '%s'", ei.getSummary());
                    this.stats.incrementCreated();
                } else {
                    MutableIssue subTaskIssue = this.createIssue(ei, validationResult);
                    this.createSubTaskLink(subTaskIssue, subtaskParentId);
                    issueKey = subTaskIssue.getKey();
                }
                this.saveNecessaryInfo(issueInputParameters, issueKey, ei);
            } else {
                this.printErrors((ServiceResult)validationResult);
            }
            this.stats.incrementProgress();
        }
    }

    private boolean shouldBeAborted() {
        if (this.isAborted()) {
            this.log.log("Abort signal detected!", new Object[0]);
            return true;
        }
        int maxIssuesPerImport = this.bulkCreateAdvancedSettings.getMaxIssuesPerImport();
        if (maxIssuesPerImport > 0 && this.createdIssueInfos.size() >= maxIssuesPerImport) {
            this.log.fail(null, "Current JIRA settings allows you to create only %d issues via single CSV file. Please check Advanced Settings to adjust this value.", maxIssuesPerImport);
            return true;
        }
        return false;
    }

    private void createSubTaskLink(MutableIssue subTaskIssue, Long parentId) {
        MutableIssue parent = this.bridgeUtils.getIssue(this.issueService, this.authenticationContext.getUser(), parentId).getIssue();
        try {
            this.bridgeUtils.createSubTaskIssueLink(this.subTaskManager, (Issue)parent, (Issue)subTaskIssue, this.authenticationContext.getUser());
        }
        catch (CreateException e) {
            this.log.warn(e, "There was a problem creating issue link between %s and %s. Error message: %s", parent.getKey(), subTaskIssue.getKey(), e.getMessage());
        }
    }

    private Either<Issue, CreatedIssueInfo> getSubtaskParentId(final ExternalIssue issue) {
        final ExternalLink subTaskLink = (ExternalLink)Iterables.getFirst((Iterable)Iterables.filter(this.links, (Predicate)new Predicate<ExternalLink>(){

            public boolean apply(ExternalLink input) {
                return input.isSubtask() && input.getSourceId().equals(issue.getExternalId());
            }
        }), null);
        if (subTaskLink == null) {
            return null;
        }
        Optional<Issue> existingIssue = this.getExistingIssue(subTaskLink.getDestinationId());
        if (existingIssue.isPresent()) {
            return Either.left((Object)existingIssue.get());
        }
        CreatedIssueInfo parent = (CreatedIssueInfo)Iterables.getFirst((Iterable)Iterables.filter(this.createdIssueInfos, (Predicate)new Predicate<CreatedIssueInfo>(){

            public boolean apply(CreatedIssueInfo input) {
                return input.getExternalId() != null && input.getExternalId().equals(subTaskLink.getDestinationId());
            }
        }), null);
        if (parent == null) {
            return null;
        }
        if (parent.getJiraIssueKey() != null) {
            Optional<Issue> linkToExistingIssue = this.getExistingIssue(parent.getJiraIssueKey());
            return Either.left((Object)linkToExistingIssue.get());
        }
        return Either.right((Object)parent);
    }

    private boolean isSubtask(ExternalIssue ei) {
        String issueType = ei.getIssueType();
        String issueTypeId = this.getIssueTypeId(issueType);
        if (issueTypeId != null) {
            IssueType issueTypeObject = this.constantsManager.getIssueTypeObject(issueTypeId);
            return issueTypeObject != null && issueTypeObject.isSubTask();
        }
        return false;
    }

    private Optional<Issue> getExistingIssue(String key) {
        IssueService.IssueResult issueResult = this.bridgeUtils.getIssue(this.issueService, this.authenticationContext.getUser(), key);
        if (issueResult.isValid()) {
            return Optional.of((Object)issueResult.getIssue());
        }
        return Optional.absent();
    }

    private void saveNecessaryInfo(IssueInputParameters issueInputParameters, String issueKey, ExternalIssue ei) {
        String[] customFieldValue;
        String epicName = null;
        if (this.epicNameCustomFieldId != null && (customFieldValue = issueInputParameters.getCustomFieldValue(this.epicNameCustomFieldId)) != null && customFieldValue.length > 0) {
            epicName = customFieldValue[0];
        }
        this.createdIssueInfos.add(new CreatedIssueInfo(ei.getExternalId(), epicName, issueKey, this.constantsManager.getIssueTypeObject(issueInputParameters.getIssueTypeId())));
    }

    private ExternalProject getProject() {
        Set<ExternalProject> selectedProjects = this.dataBean.getSelectedProjects(this.log);
        if (selectedProjects.size() != 1) {
            throw new IllegalStateException("Only one project is allowed!");
        }
        return selectedProjects.iterator().next();
    }

    private MutableIssue createIssue(ExternalIssue ei, IssueService.CreateValidationResult validationResult) {
        IssueService.IssueResult issueResult = this.bridgeUtils.create(this.issueService, this.authenticationContext.getUser(), validationResult);
        MutableIssue issue = issueResult.getIssue();
        if (!issueResult.isValid()) {
            this.printErrors((ServiceResult)validationResult);
        } else {
            this.log.log("Issue created successfully with Key [%s], %s", issue.getKey(), ei);
            this.stats.incrementCreated();
            this.importInfo.setLastCreatedIssue((Issue)issue);
        }
        return issue;
    }

    private void finalizeImport() {
        ImporterFinishedEvent finishedEvent = new ImporterFinishedEvent(this.isValidationMode ? "BulkCreate" : "BulkCreateValidation", this.stats.getUsersStage().getItemsCreated(), this.stats.getIssuesStage().getItemsCreated(), this.stats.getProjectsStage().getItemsCreated(), this.stats.getUsersStage().getItemsToBeImported(), this.stats.getIssuesStage().getItemsToBeImported(), this.stats.getProjectsStage().getItemsToBeImported(), this.stats.getIssuesStage().getItemsUpdated(), this.stats.getFailures().size(), this.stats.getWarnings().size(), this.stats.getElapsedTime());
        finishedEvent.setImporter(this);
        this.eventPublisher.publish((Object)finishedEvent);
        this.project = null;
        this.epicNameCustomFieldId = null;
        this.isValidationMode = false;
        this.dataBean.cleanUp();
        this.dataBean = null;
        this.createdIssueInfos = null;
    }

    private void printErrors(ServiceResult validationResult) {
        if (validationResult.isValid()) {
            return;
        }
        Collection errorValues = validationResult.getErrorCollection().getErrors().values();
        ImmutableList errorMessages = ImmutableList.builder().addAll(errorValues).addAll((Iterable)validationResult.getErrorCollection().getErrorMessages()).build();
        this.log.fail(null, "Issue can't be created due to the error/s [ %s ]", Joiner.on((String)"; ").join((Iterable)errorMessages));
    }

    private String[] prepareLabelSet(Set<String> labels) {
        Iterable cleanLabels = Iterables.filter((Iterable)Iterables.transform(labels, (Function)new Function<String, String>(){

            public String apply(String label) {
                return LabelParser.getCleanLabel((String)label);
            }
        }), (Predicate)Predicates.notNull());
        ArrayList list = Lists.newArrayList((Iterable)cleanLabels);
        return list.toArray(new String[list.size()]);
    }

    private IssueInputParameters externalIssueToInputParams(ExternalIssue ei) {
        String priorityId;
        Long[] componentsIds;
        IssueInputParametersImpl inputParams = ei.getLabels().size() > 0 ? new IssueInputParametersImpl((Map)ImmutableMap.builder().put((Object)"labels", (Object)this.prepareLabelSet(ei.getLabels())).build()) : new IssueInputParametersImpl();
        inputParams.setApplyDefaultValuesWhenParameterNotProvided(true);
        inputParams.setRetainExistingValuesWhenParameterNotProvided(true);
        inputParams.setProjectId(this.project.getId());
        inputParams.setSummary(ei.getSummary());
        inputParams.setComment(this.getComment(ei));
        Long[] affectedVersions = this.getVersionIds(ei.getAffectedVersions());
        Long[] fixedVersions = this.getVersionIds(ei.getFixedVersions());
        if (affectedVersions.length > 0) {
            inputParams.setAffectedVersionIds(affectedVersions);
        }
        if (fixedVersions.length > 0) {
            inputParams.setFixVersionIds(fixedVersions);
        }
        if (ei.getAssignee() != null) {
            inputParams.setAssigneeId(ei.getAssignee());
        }
        if (ei.getReporter() != null) {
            inputParams.setReporterId(ei.getReporter());
        }
        if ((componentsIds = this.getComponentsIds(ei.getComponents())).length > 0) {
            inputParams.setComponentIds(componentsIds);
        }
        if (ei.getDescription() != null) {
            inputParams.setDescription(ei.getDescription());
        }
        if (ei.getDuedate() != null) {
            String formattedDate = this.dateFieldFormat.formatDatePicker(ei.getDuedate().toDate());
            inputParams.setDueDate(formattedDate);
        }
        if (ei.getEnvironment() != null) {
            inputParams.setEnvironment(ei.getEnvironment());
        }
        if (ei.getPriority() != null && (priorityId = this.getPriorityId(ei.getPriority())) != null) {
            inputParams.setPriorityId(priorityId);
        }
        this.handleTimeTracking(ei, (IssueInputParameters)inputParams);
        this.handleCustomFields(ei, (IssueInputParameters)inputParams);
        if (StringUtils.isNotBlank((String)ei.getIssueType())) {
            String issueTypeId = this.getIssueTypeId(ei.getIssueType());
            if (issueTypeId == null) {
                IssueType defaultIssueType = this.getDefaultIssueType();
                this.log.warn("The issue type [ %s ] does not exist or it's not applicable for the selected project. The affected issues will be created with issue type [ %s ]", ei.getIssueType(), defaultIssueType.getNameTranslation());
                issueTypeId = defaultIssueType.getId();
            }
            inputParams.setIssueTypeId(issueTypeId);
        } else {
            IssueType defaultIssueType = this.issueTypeSchemeManager.getDefaultIssueType(this.project);
            if (defaultIssueType != null) {
                this.log.log("Issue does not have issue type selected, the affected issues will be created with default issue type [%s]", defaultIssueType.getNameTranslation());
                inputParams.setIssueTypeId(defaultIssueType.getId());
            } else {
                IssueType firstIssueType = (IssueType)this.issueTypeSchemeManager.getIssueTypesForProject(this.project).iterator().next();
                this.log.log("Issue does not have issue type selected, the affected issues will be created with issue type [%s]", firstIssueType.getNameTranslation());
                inputParams.setIssueTypeId(firstIssueType.getId());
            }
        }
        return inputParams;
    }

    private void handleTimeTracking(ExternalIssue ei, IssueInputParameters inputParams) {
        long estimate;
        String defaultDateUnit = this.applicationProperties.getDefaultBackedString("jira.timetracking.default.unit");
        DateUtils.Duration duration = defaultDateUnit != null ? DateUtils.Duration.valueOf((String)defaultDateUnit) : DateUtils.Duration.HOUR;
        Map actionParameters = inputParams.getActionParameters();
        if (this.applicationProperties.getOption("jira.timetracking.estimates.legacy.behaviour")) {
            if (ei.getOriginalEstimate() != null) {
                long original = (long)ei.getOriginalEstimate().getSeconds() / duration.getSeconds();
                inputParams.setOriginalEstimate(Long.valueOf(original));
            }
        } else {
            String[] originalEstimateParam;
            if (ei.getOriginalEstimate() != null) {
                long originalEstimate = (long)ei.getOriginalEstimate().getSeconds() / duration.getSeconds();
                originalEstimateParam = new String[]{String.valueOf(originalEstimate)};
            } else {
                originalEstimateParam = new String[]{};
            }
            actionParameters.put("timetracking_originalestimate", originalEstimateParam);
        }
        if (ei.getTimeSpent() != null && ei.getEstimate() != null) {
            estimate = (long)ei.getEstimate().getSeconds() / duration.getSeconds();
            long timeSpent = (long)ei.getTimeSpent().getSeconds() / duration.getSeconds();
            actionParameters.put("worklog", new String[0]);
            actionParameters.put("worklog_activate", new String[]{String.valueOf(true)});
            actionParameters.put("worklog_timeLogged", new String[]{String.valueOf(timeSpent)});
            actionParameters.put("worklog_startDate", new String[]{this.getCurrentDateFormatted()});
            actionParameters.put("worklog_adjustEstimate", new String[]{"new"});
            actionParameters.put("worklog_newEstimate", new String[]{String.valueOf(estimate)});
        } else if (ei.getEstimate() != null) {
            estimate = (long)ei.getEstimate().getSeconds() / duration.getSeconds();
            actionParameters.put("timetracking_remainingestimate", new String[]{String.valueOf(estimate)});
        } else if (ei.getTimeSpent() != null) {
            long timeSpent = (long)ei.getTimeSpent().getSeconds() / duration.getSeconds();
            actionParameters.put("worklog", new String[0]);
            actionParameters.put("worklog_activate", new String[]{String.valueOf(true)});
            actionParameters.put("worklog_timeLogged", new String[]{String.valueOf(timeSpent)});
            actionParameters.put("worklog_startDate", new String[]{this.getCurrentDateFormatted()});
            actionParameters.put("worklog_adjustEstimate", new String[]{"leave"});
        }
    }

    private String getCurrentDateFormatted() {
        return this.dateTimeFormatter.forLoggedInUser().withStyle(DateTimeStyle.DATE_TIME_PICKER).format(new Date());
    }

    private void handleCustomFields(ExternalIssue ei, IssueInputParameters inputParams) {
        for (ExternalCustomFieldValue customFieldValue : ei.getExternalCustomFieldValues()) {
            String[] epicNames;
            Optional<CustomField> customField = this.customFieldsHelper.getCustomField(customFieldValue, this.project);
            if (this.isValidationMode && this.isEpicLinkField(customField) && (epicNames = this.customFieldsHelper.resultToArray(customFieldValue.getValue())) != null && epicNames.length > 0 && this.isEpicWithName(epicNames[0])) continue;
            Optional<String[]> preparedValue = this.customFieldsHelper.prepareValueForCustomFields(customFieldValue, this.project, this.log);
            if (customField.isPresent() && preparedValue.isPresent()) {
                inputParams.addCustomFieldValue(((CustomField)customField.get()).getId(), (String[])preparedValue.get());
            } else if (customField.isPresent()) {
                this.log.warn("The value [ %s ] can't be added to the Custom Field [ %s ]. The value [ %s ] can't be found or is in the incorrect format", customFieldValue.getValue(), ((CustomField)customField.get()).getFieldName(), customFieldValue.getValue());
            }
            if (!customField.isPresent() || !"com.pyxis.greenhopper.jira:gh-epic-label".equals(((CustomField)customField.get()).getCustomFieldType().getKey())) continue;
            this.epicNameCustomFieldId = ((CustomField)customField.get()).getIdAsLong();
        }
    }

    private boolean isEpicWithName(final String epicName) {
        return Iterables.any(this.createdIssueInfos, (Predicate)new Predicate<CreatedIssueInfo>(){

            public boolean apply(CreatedIssueInfo input) {
                return epicName.equals(input.getEpicName());
            }
        });
    }

    private boolean isEpicLinkField(Optional<CustomField> customField) {
        return customField.isPresent() && "com.pyxis.greenhopper.jira:gh-epic-link".equals(((CustomField)customField.get()).getCustomFieldType().getKey());
    }

    public IssueType getDefaultIssueType() {
        IssueType defaultIssueType = this.issueTypeSchemeManager.getDefaultIssueType(this.project);
        return defaultIssueType == null ? (IssueType)this.issueTypeSchemeManager.getIssueTypesForProject(this.project).iterator().next() : defaultIssueType;
    }

    private String getPriorityId(String priority) {
        return this.getConstantIdByName(this.constantsManager.getPriorityObjects(), priority);
    }

    private String getIssueTypeId(String issueTypeName) {
        return this.getConstantIdByName(this.issueTypeSchemeManager.getIssueTypesForProject(this.project), issueTypeName);
    }

    private <T extends IssueConstant> String getConstantIdByName(Iterable<T> constants, final String name) {
        Iterable matchingConstant = Iterables.filter(constants, (Predicate)new Predicate<IssueConstant>(){

            public boolean apply(IssueConstant input) {
                return input.getName().equalsIgnoreCase(name) || input.getId().equalsIgnoreCase(name) || input.getNameTranslation().equalsIgnoreCase(name);
            }
        });
        IssueConstant constant = (IssueConstant)Iterables.getFirst((Iterable)matchingConstant, null);
        return constant != null ? constant.getId() : null;
    }

    private Long[] getVersionIds(Iterable<String> versions) {
        if (versions == null) {
            return new Long[0];
        }
        Iterable noNullVersions = Iterables.filter(versions, (Predicate)Predicates.notNull());
        Iterable versionIds = Iterables.transform((Iterable)noNullVersions, (Function)new Function<String, Long>(){

            public Long apply(String input) {
                Version version = BulkCreateDataImporter.this.versionManager.getVersion(BulkCreateDataImporter.this.project.getId(), input);
                if (version == null) {
                    BulkCreateDataImporter.this.log.warn("The version %s doesn't exist in this project and can't be added", input);
                    return null;
                }
                return version.getId();
            }
        });
        return (Long[])Iterables.toArray((Iterable)Iterables.filter((Iterable)versionIds, (Predicate)Predicates.notNull()), Long.class);
    }

    private Long[] getComponentsIds(Iterable<String> components) {
        if (components == null) {
            return new Long[0];
        }
        Iterable noNullComponents = Iterables.filter(components, (Predicate)Predicates.notNull());
        Iterable componentsIds = Iterables.transform((Iterable)noNullComponents, (Function)new Function<String, Long>(){

            public Long apply(@Nullable String input) {
                ProjectComponent projectComponent = BulkCreateDataImporter.this.projectComponentManager.findByComponentName(BulkCreateDataImporter.this.project.getId(), input);
                if (projectComponent == null) {
                    BulkCreateDataImporter.this.log.warn("The component %s doesn't exist in this project and can't be added", input);
                    return null;
                }
                return projectComponent.getId();
            }
        });
        return (Long[])Iterables.toArray((Iterable)Iterables.filter((Iterable)componentsIds, (Predicate)Predicates.notNull()), Long.class);
    }

    private String getComment(ExternalIssue ei) {
        List<ExternalComment> comments = ei.getComments();
        return comments.size() > 0 ? comments.get(0).getBody() : null;
    }

    @Override
    @Nullable
    public PostImportInformations.ImportInfo getInfo() {
        return this.importInfo;
    }

    @Override
    public void initializeLog() {
        this.aborted.set(false);
        this.stats = new ImportStats(new DateUtils(this.authenticationContext.getI18nHelper().getDefaultResourceBundle()), this.authenticationContext.getI18nHelper());
        this.log = new ValidableFileImportLogger(this.getLogFile());
        ((AbstractDataImporter)this).log = this.log;
    }

    private class ValidableFileImportLogger
    extends FileImportLogger {
        private String currentIssue;
        private Set<String> issuesWithWarnings;

        public ValidableFileImportLogger(File output) {
            super(output);
            this.issuesWithWarnings = Sets.newHashSet();
        }

        @Override
        public void fail(@Nullable Throwable e, String fmt, Object ... args) {
            super.fail(e, fmt, args);
            this.incrementFailures(fmt, args);
        }

        private void incrementFailures(String fmt, Object ... args) {
            if (BulkCreateDataImporter.this.stats != null) {
                BulkCreateDataImporter.this.stats.incrementFailures(String.format(fmt, args));
            }
        }

        private void incrementWarnings(String fmt, Object ... args) {
            if (BulkCreateDataImporter.this.stats != null) {
                BulkCreateDataImporter.this.stats.incrementWarnings(String.format(fmt, args));
            }
        }

        @Override
        public void warn(@Nullable Throwable e, String s, Object ... args) {
            super.warn(e, s, args);
            this.setIssueWithWarning(this.currentIssue);
            this.incrementWarnings(s, args);
        }

        @Override
        public void warn(String fmt, Object ... args) {
            super.warn(fmt, args);
            this.incrementWarnings(fmt, args);
        }

        public void setCurrentIssue(String id) {
            this.currentIssue = id;
        }

        public boolean isCurrentIssueWithWarnings(String issueId) {
            return this.issuesWithWarnings.contains(issueId);
        }

        public void setIssueWithWarning(String issueId) {
            if (issueId != null && !this.issuesWithWarnings.contains(issueId)) {
                this.issuesWithWarnings.add(issueId);
                BulkCreateDataImporter.this.stats.incrementCreatedWithWarnings();
            }
        }
    }
}

