/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.bulkcreate.controller;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.CoreFeatures;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.plugins.importer.extensions.ImporterController2;
import com.atlassian.jira.plugins.importer.web.ImportProcessBean;
import javax.annotation.Nullable;
import javax.servlet.http.HttpSession;
import webwork.action.ActionContext;

public abstract class AbstractImporterController2
implements ImporterController2 {
    private final String importerId;
    private final String sessionAttributeName;

    protected AbstractImporterController2(String importerId, String sessionAttributeName) {
        this.importerId = importerId;
        this.sessionAttributeName = sessionAttributeName;
    }

    @Override
    public String getProgressPageName() {
        return "ImporterLogsPage!import.jspa";
    }

    @Override
    public String getFinishedPageName() {
        return "ImporterFinishedPage!default.jspa";
    }

    @Override
    public boolean isUsingConfiguration() {
        return true;
    }

    @Override
    public String getId() {
        return this.importerId;
    }

    @Override
    public String getSection() {
        boolean isOnDemand = ((FeatureManager)ComponentAccessor.getComponent(FeatureManager.class)).isEnabled(CoreFeatures.ON_DEMAND);
        return "admin_system_menu/JIMMainSection/" + (isOnDemand ? "Studio" : this.getId());
    }

    @Override
    public ImportProcessBean getImportProcessBeanFromSession() {
        try {
            return (ImportProcessBean)ActionContext.getSession().get(this.sessionAttributeName);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public ImportProcessBean getImportProcessBean(HttpSession session) {
        try {
            return (ImportProcessBean)session.getAttribute(this.sessionAttributeName);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    protected void storeImportProcessBeanInSession(@Nullable ImportProcessBean bean) {
        ActionContext.getSession().put(this.sessionAttributeName, bean);
    }
}

