/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.bulkcreate;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import webwork.action.Action;

public class VisibleFieldsHelper {
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final IssueFactory issueFactory;
    private final FieldScreenRendererFactory fieldScreenRendererFactory;
    private Project project;
    private Set<OrderableField> allowedFields;
    public static final OperationContext EMPTY_CREATE_OPERATION_CONTEXT = new OperationContext(){

        public Map<String, Object> getFieldValuesHolder() {
            return Maps.newHashMap();
        }

        public IssueOperation getIssueOperation() {
            return IssueOperations.CREATE_ISSUE_OPERATION;
        }
    };

    public VisibleFieldsHelper(IssueTypeSchemeManager issueTypeSchemeManager, IssueFactory issueFactory, FieldScreenRendererFactory fieldScreenRendererFactory) {
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.issueFactory = issueFactory;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
    }

    public synchronized Set<OrderableField> getVisibleFields(Project project, Action action, ApplicationUser user) {
        if (this.allowedFields == null) {
            this.project = (Project)Preconditions.checkNotNull((Object)project);
            this.allowedFields = Sets.newHashSet();
            this.calculateVisibleFields(action, user);
        }
        return this.allowedFields;
    }

    private void calculateVisibleFields(Action action, ApplicationUser user) {
        Collection issueTypesForProject = this.issueTypeSchemeManager.getIssueTypesForProject(this.project);
        for (IssueType issueType : issueTypesForProject) {
            MutableIssue issue = this.prepareTemporaryIssue(issueType);
            FieldScreenRenderer fieldScreenRenderer = this.fieldScreenRendererFactory.getFieldScreenRenderer((Issue)issue, (IssueOperation)IssueOperations.CREATE_ISSUE_OPERATION);
            List visibleLayoutItems = fieldScreenRenderer.getFieldLayout().getVisibleLayoutItems(this.project, (List)ImmutableList.of((Object)issueType.getId()));
            this.addOnlyVisibleFields(issue, fieldScreenRenderer, visibleLayoutItems, action);
        }
    }

    private void addOnlyVisibleFields(final MutableIssue issue, final FieldScreenRenderer fieldScreenRenderer, List<FieldLayoutItem> visibleCustomFieldLayoutItems, final Action action) {
        Iterable fields = Iterables.transform(visibleCustomFieldLayoutItems, (Function)new Function<FieldLayoutItem, OrderableField>(){

            public OrderableField apply(FieldLayoutItem input) {
                OrderableField orderableField = input.getOrderableField();
                if (VisibleFieldsHelper.this.allowedFields.contains(orderableField)) {
                    return null;
                }
                FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem = fieldScreenRenderer.getFieldScreenRenderLayoutItem(orderableField);
                if (fieldScreenRenderLayoutItem == null || !fieldScreenRenderLayoutItem.isShow((Issue)issue)) {
                    return null;
                }
                String createHtml = fieldScreenRenderLayoutItem.getCreateHtml(action, EMPTY_CREATE_OPERATION_CONTEXT, (Issue)issue);
                if (StringUtils.isBlank((CharSequence)createHtml)) {
                    return null;
                }
                return orderableField;
            }
        });
        Iterable newFields = Iterables.filter((Iterable)fields, (Predicate)Predicates.notNull());
        this.allowedFields.addAll(Lists.newArrayList((Iterable)newFields));
    }

    private MutableIssue prepareTemporaryIssue(IssueType issueType) {
        MutableIssue issue = this.issueFactory.getIssue();
        issue.setProjectId(this.project.getId());
        issue.setIssueTypeId(issueType.getId());
        return issue;
    }
}

