/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.bulkcreate;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.plugins.importer.imports.bulkcreate.controller.AbstractImporterController2;
import com.atlassian.jira.plugins.importer.imports.bulkcreate.controller.BulkCreateImporterStorage;
import com.atlassian.jira.plugins.importer.imports.bulkcreate.web.BulkCreateFieldMapping;
import com.atlassian.jira.plugins.importer.imports.bulkcreate.web.BulkCreateSettingsPage;
import com.atlassian.jira.plugins.importer.imports.bulkcreate.web.BulkCreateSetupPage;
import com.atlassian.jira.plugins.importer.imports.bulkcreate.web.BulkCreateValueMappingPage;
import com.atlassian.jira.plugins.importer.imports.csv.CsvDataBeanBuilder;
import com.atlassian.jira.plugins.importer.imports.csv.mappers.StaticProjectMapper;
import com.atlassian.jira.plugins.importer.imports.importer.ImportDataBean;
import com.atlassian.jira.plugins.importer.imports.importer.PostImportInformations;
import com.atlassian.jira.plugins.importer.imports.importer.ValidableJiraDataImporter;
import com.atlassian.jira.plugins.importer.web.AbstractSetupPage;
import com.atlassian.jira.plugins.importer.web.ImportProcessBean;
import com.atlassian.jira.plugins.importer.web.csv.GoodCsvConfigBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.timezone.TimeZoneInfo;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.jira.util.DateFieldFormat;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class BulkCreateImportController
extends AbstractImporterController2 {
    public static final String IMPORTER_ID = "BulkCreate";
    private final CustomFieldManager customFieldManager;
    private final IssueManager issueManager;
    private final AttachmentManager attachmentManager;
    private final JiraHome jiraHome;
    private final JiraAuthenticationContext authenticationContext;
    private final TimeZoneService timeZoneService;
    private final BulkCreateImporterStorage importerStorage;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final DateFieldFormat formatter;
    private final DateTimeFormatter dateTimeFormatter;

    public BulkCreateImportController(@ComponentImport CustomFieldManager customFieldManager, @ComponentImport IssueManager issueManager, @ComponentImport AttachmentManager attachmentManager, @ComponentImport JiraHome jiraHome, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport TimeZoneService timeZoneService, BulkCreateImporterStorage importerStorage, @ComponentImport IssueLinkTypeManager issueLinkTypeManager, @ComponentImport DateFieldFormat formatter, @ComponentImport DateTimeFormatter dateTimeFormatter) {
        super(IMPORTER_ID, "bcKey");
        this.customFieldManager = customFieldManager;
        this.issueManager = issueManager;
        this.attachmentManager = attachmentManager;
        this.jiraHome = jiraHome;
        this.authenticationContext = authenticationContext;
        this.timeZoneService = timeZoneService;
        this.importerStorage = importerStorage;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.formatter = formatter;
        this.dateTimeFormatter = dateTimeFormatter;
    }

    @Override
    public ValidableJiraDataImporter getImporter() {
        return this.importerStorage.getImporter(this.authenticationContext.getUser());
    }

    @Override
    public String getReturnLinks(PostImportInformations.ImportInfo importInfo) {
        String firstIssueKey = importInfo.getFirstIssueKey();
        JiraBaseUrls jiraBaseUrls = (JiraBaseUrls)ComponentAccessor.getComponent(JiraBaseUrls.class);
        if (StringUtils.isNotEmpty((String)firstIssueKey)) {
            return String.format("<div id=\"importAgain\"><a href=\"%s\">%s</a></div>", jiraBaseUrls.baseUrl() + "/issues/?jql=project%3D" + importInfo.getProject().getKey() + "%20AND%20issuekey>%3D" + firstIssueKey + "%20AND%20issuekey<%3D" + importInfo.getLastIssueKey() + "%20AND%20creator%3DcurrentUser()", this.authenticationContext.getI18nHelper().getText("jira-importer-plugin.bc.link"));
        }
        return String.format("<div id=\"importAgain\"><a href=\"%s\">%s</a></div>", jiraBaseUrls.baseUrl() + "/issues/?jql=project%3D" + importInfo.getProject().getKey(), this.authenticationContext.getI18nHelper().getText("jira-importer-plugin.bc.link"));
    }

    @Override
    public boolean createImportProcessBean(AbstractSetupPage setupPage) {
        if (!(setupPage instanceof BulkCreateSetupPage)) {
            throw new IllegalStateException();
        }
        BulkCreateSetupPage page = (BulkCreateSetupPage)setupPage;
        GoodCsvConfigBean configBean = new GoodCsvConfigBean();
        configBean.setCsvFilePath(page.getTempAttachment().getFile());
        TimeZoneInfo timeZoneInfo = this.timeZoneService.getUserTimeZoneInfo((JiraServiceContext)new JiraServiceContextImpl(this.authenticationContext.getUser()));
        configBean.setTimeZoneInfo(timeZoneInfo);
        if (page.isConfigFileAttached()) {
            try {
                configBean.copyFromProperties(page.getMultipart().getFile("configFile"));
            }
            catch (Exception e) {
                page.addErrorMessage(page.getText("jira-importer-plugin.bc.setup.config.reading.error"));
                return false;
            }
        }
        ImportProcessBean bean = new ImportProcessBean();
        bean.setConfigBean(configBean);
        this.storeImportProcessBeanInSession(bean);
        return true;
    }

    @Override
    public ImportDataBean createDataBean() throws Exception {
        ImportProcessBean importProcessBean = this.getImportProcessBeanFromSession();
        GoodCsvConfigBean configBean = (GoodCsvConfigBean)importProcessBean.getConfigBean();
        return new CsvDataBeanBuilder(configBean, this.jiraHome, this.issueManager, this.attachmentManager, this.formatter, this.dateTimeFormatter, this.issueLinkTypeManager, this.customFieldManager).projectMapper(new StaticProjectMapper(configBean.getPickedProject())).build();
    }

    @Override
    public List<String> getSteps() {
        return ImmutableList.of((Object)BulkCreateSetupPage.class.getSimpleName(), (Object)BulkCreateSettingsPage.class.getSimpleName(), (Object)BulkCreateFieldMapping.class.getSimpleName(), (Object)BulkCreateValueMappingPage.class.getSimpleName());
    }

    @Override
    public List<String> getStepNameKeys() {
        I18nHelper helper = this.authenticationContext.getI18nHelper();
        return ImmutableList.of((Object)helper.getText("jira-importer-plugin.bc.setup.title"), (Object)helper.getText("jira-importer-plugin.bc.settings.title"), (Object)helper.getText("jira-importer-plugin.bc.field.mapping.title"), (Object)helper.getText("jira-importer-plugin.bc.value.mapping.title"));
    }
}

