/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.bulkcreate;

import com.atlassian.jira.bc.admin.ApplicationPropertiesService;
import com.atlassian.jira.bc.admin.ApplicationProperty;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BulkCreateAdvancedSettings {
    private static final String MAX_ISSUES_ADVANCED_SETTING_KEY = "jira.bulk.create.max.issues.per.import";
    private static final Logger log = Logger.getLogger(BulkCreateAdvancedSettings.class);
    private final ApplicationPropertiesService propertiesService;

    @Autowired
    public BulkCreateAdvancedSettings(@ComponentImport ApplicationPropertiesService propertiesService) {
        this.propertiesService = propertiesService;
    }

    public int getMaxIssuesPerImport() {
        ApplicationProperty applicationProperty = this.propertiesService.getApplicationProperty(MAX_ISSUES_ADVANCED_SETTING_KEY);
        int intValue = -1;
        if (applicationProperty != null) {
            String currentValue = applicationProperty.getCurrentValue();
            try {
                intValue = Integer.parseInt(currentValue);
            }
            catch (NumberFormatException e) {
                log.warn((Object)String.format("Cannot read value of advanced setting: '%s'", MAX_ISSUES_ADVANCED_SETTING_KEY), (Throwable)e);
                intValue = -1;
            }
        }
        return intValue;
    }
}

