/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.bugzilla.transformer;

import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.imports.AbstractResultSetTransformer;
import com.atlassian.jira.plugins.importer.imports.bugzilla.BugzillaConfigBean;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.opensymphony.util.TextUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class UserTransformer
extends AbstractResultSetTransformer<ExternalUser> {
    protected final BugzillaConfigBean configBean;

    public UserTransformer(BugzillaConfigBean configBean, ImportLogger log) {
        super(log);
        this.configBean = configBean;
    }

    @Override
    public String getSqlQuery() {
        return "SELECT userid, login_name, realname, disabledtext FROM profiles";
    }

    @Override
    @Nullable
    public ExternalUser transform(ResultSet rs) throws SQLException {
        String fullName = rs.getString("realname");
        String email = TextUtils.noNull((String)rs.getString("login_name"));
        String username = this.configBean.getUsernameForLoginName(email);
        boolean active = StringUtils.isEmpty((String)rs.getString("disabledtext"));
        if (StringUtils.isBlank((String)username)) {
            this.log.warn("Username is blank and is not imported", new Object[0]);
            return null;
        }
        ExternalUser user = new ExternalUser(username, StringUtils.isEmpty((String)fullName) ? this.getFullNameFromEmail(email) : fullName, email);
        if (!active) {
            user.setActive(false);
            user.getGroups().add(this.configBean.getInactiveUsersGroup());
        }
        return user;
    }

    public String getFullNameFromEmail(String email) {
        if (email == null) {
            return "";
        }
        int index = email.indexOf("@");
        if (index != -1) {
            return email.substring(0, index);
        }
        return "";
    }
}

