/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.bugzilla.transformer;

import com.atlassian.jira.issue.customfields.converters.DateTimePickerConverter;
import com.atlassian.jira.plugins.importer.SqlUtils;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomField;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.external.beans.ExternalWorklog;
import com.atlassian.jira.plugins.importer.imports.AbstractIssueTransformer;
import com.atlassian.jira.plugins.importer.imports.bugzilla.BugzillaConfigBean;
import com.atlassian.jira.plugins.importer.imports.bugzilla.transformer.CommentTransformer;
import com.atlassian.jira.plugins.importer.imports.bugzilla.transformer.CustomMultiSelectTransformer;
import com.atlassian.jira.plugins.importer.imports.bugzilla.transformer.IssueTransformerBugzilla22;
import com.atlassian.jira.plugins.importer.imports.bugzilla.transformer.VotesTransformer;
import com.atlassian.jira.plugins.importer.imports.bugzilla.transformer.WatchersTransformer;
import com.atlassian.jira.plugins.importer.imports.bugzilla.transformer.WorklogTransformer;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.importer.SingleStringResultTransformer;
import com.atlassian.jira.plugins.importer.web.JdbcConnection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class IssueTransformer
extends AbstractIssueTransformer<BugzillaConfigBean> {
    private static final int SECONDS_IN_HOUR = 3600;
    protected final ExternalProject externalProject;
    private final String bugzillaUrl;
    private final DateTimePickerConverter dateTimePicker;
    private final boolean hasVotes;

    public IssueTransformer(String bugzillaUrl, BugzillaConfigBean configBean, ExternalProject externalProject, DateTimePickerConverter dateTimePicker, ImportLogger importLogger, boolean hasVotes) {
        super(configBean, importLogger);
        this.bugzillaUrl = bugzillaUrl;
        this.externalProject = externalProject;
        this.dateTimePicker = dateTimePicker;
        this.hasVotes = hasVotes;
    }

    public static IssueTransformer create(JdbcConnection jdbcConnection, String bugzillaUrl, BugzillaConfigBean configBean, ExternalProject externalProject, DateTimePickerConverter dateTimePicker, ImportLogger importLogger) {
        try {
            if (SqlUtils.getColumnNames(jdbcConnection.getConnection(), "longdescs").contains("comment_id")) {
                return new IssueTransformer(bugzillaUrl, configBean, externalProject, dateTimePicker, importLogger, SqlUtils.hasTable(jdbcConnection.getConnection(), "votes"));
            }
            return new IssueTransformerBugzilla22(bugzillaUrl, configBean, externalProject, dateTimePicker, importLogger, SqlUtils.hasTable(jdbcConnection.getConnection(), "votes"));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getSqlQuery() {
        return "SELECT b.*,p1.login_name as reporter_name,p2.login_name as assignee_name,l.thetext,c.name as component FROM bugs AS b, components AS c, longdescs AS l, profiles AS p1, profiles as p2 WHERE b.product_id = " + this.externalProject.getId() + " AND comment_id = (select min(l2.comment_id) from longdescs as l2 where l2.bug_id = l.bug_id) AND b.component_id = c.id AND l.bug_id = b.bug_id AND p1.userid=b.reporter AND p2.userid=b.assigned_to ORDER BY b.bug_id;";
    }

    @Override
    public ExternalIssue transform(ResultSet rs) throws SQLException {
        String assignee;
        String reporter;
        String fixFor;
        String version;
        String summary = rs.getString("short_desc");
        if (StringUtils.isEmpty((String)summary)) {
            this.log.warn("Summary is blank and is not imported", new Object[0]);
            return null;
        }
        String oldId = rs.getString("bug_id");
        ExternalIssue externalIssue = new ExternalIssue();
        externalIssue.setExternalId(oldId);
        externalIssue.setSummary(summary);
        externalIssue.setDescription(rs.getString("thetext"));
        externalIssue.setIssueType("enhancement".equals(rs.getString("bug_severity")) ? "Improvement" : "Bug");
        StringBuilder environment = new StringBuilder();
        environment.append("Operating System: ").append(rs.getString("op_sys")).append("\nPlatform: ").append(rs.getString("rep_platform"));
        String url = rs.getString("bug_file_loc");
        if (!StringUtils.isEmpty((String)url)) {
            environment.append("\nURL: ").append(url);
        }
        externalIssue.setEnvironment(environment.toString());
        String component = rs.getString("component");
        if (StringUtils.isNotBlank((String)component)) {
            externalIssue.setComponents(Collections.singleton(component));
        }
        if (StringUtils.isNotBlank((String)(version = rs.getString("version")))) {
            externalIssue.setAffectedVersions(Collections.singleton(version));
        }
        if (StringUtils.isNotBlank((String)(fixFor = rs.getString("target_milestone")))) {
            externalIssue.setFixedVersions(Collections.singleton(fixFor));
        }
        if (StringUtils.isNotEmpty((String)(reporter = rs.getString("reporter_name")))) {
            externalIssue.setReporter(((BugzillaConfigBean)this.configBean).getUsernameForLoginName(reporter));
        }
        if (StringUtils.isNotEmpty((String)(assignee = rs.getString("assignee_name")))) {
            externalIssue.setAssignee(((BugzillaConfigBean)this.configBean).getUsernameForLoginName(assignee));
        }
        externalIssue.setCreated(rs.getTimestamp("creation_ts"));
        externalIssue.setDuedate(rs.getTimestamp("deadline"));
        externalIssue.setLabels(this.jdbcConnection.queryDb(new SingleStringResultTransformer("SELECT keyworddefs.name FROM keyworddefs  INNER JOIN keywords ON keywordid = keyworddefs.id WHERE keywords.bug_id = " + oldId)));
        Timestamp closed = rs.getTimestamp("delta_ts");
        Timestamp resolved = rs.getTimestamp("delta_ts");
        externalIssue.setResolutionDate(resolved);
        if (closed != null && resolved == null) {
            externalIssue.setUpdated(closed);
        } else if (closed == null && resolved != null) {
            externalIssue.setUpdated(resolved);
        } else if (closed != null) {
            if (closed.after(resolved)) {
                externalIssue.setUpdated(closed);
            } else {
                externalIssue.setUpdated(resolved);
            }
        }
        this.setCustomFieldValues(externalIssue, rs, oldId);
        externalIssue.setStatus(((BugzillaConfigBean)this.configBean).getValueMappingHelper().getValueMappingForImport("bug_status", rs.getString("bug_status")));
        externalIssue.setResolution(((BugzillaConfigBean)this.configBean).getValueMappingHelper().getValueMappingForImport("resolution", rs.getString("resolution")));
        CommentTransformer commentTransformer = new CommentTransformer(oldId, (BugzillaConfigBean)this.configBean);
        List<ExternalComment> comments = this.jdbcConnection.queryDb(commentTransformer);
        externalIssue.setComments(comments);
        long originalEstimate = rs.getLong("estimated_time") * 3600L;
        long currentEstimate = rs.getLong("remaining_time") * 3600L;
        if (this.hasVotes) {
            VotesTransformer votesTransformer = new VotesTransformer(oldId, (BugzillaConfigBean)this.configBean);
            externalIssue.setVoters(this.jdbcConnection.queryDb(votesTransformer));
        }
        WatchersTransformer watchersTransformer = new WatchersTransformer(oldId, (BugzillaConfigBean)this.configBean);
        externalIssue.setWatchers(this.jdbcConnection.queryDb(watchersTransformer));
        externalIssue.setOriginalEstimate(originalEstimate > 0L ? Long.valueOf(originalEstimate) : null);
        externalIssue.setEstimate(currentEstimate > 0L ? Long.valueOf(currentEstimate) : null);
        WorklogTransformer worklogTransformer = new WorklogTransformer(oldId, (BugzillaConfigBean)this.configBean);
        List<ExternalWorklog> worklog = this.jdbcConnection.queryDb(worklogTransformer);
        externalIssue.setWorklogs(worklog);
        return externalIssue;
    }

    @Override
    @Nullable
    protected Object getCustomFieldValue(ResultSet rs, String bugId, ExternalCustomField customField) throws SQLException {
        if ("bug_url".equals(customField.getId())) {
            return this.bugzillaUrl + (this.bugzillaUrl.endsWith("/") ? "" : "/") + "show_bug.cgi?id=" + bugId;
        }
        if ("com.atlassian.jira.plugin.system.customfieldtypes:multiselect".equals(customField.getTypeKey())) {
            return this.jdbcConnection.queryDb(new CustomMultiSelectTransformer(bugId, (BugzillaConfigBean)this.configBean, customField.getId()));
        }
        if ("com.atlassian.jira.plugin.system.customfieldtypes:datetime".equals(customField.getTypeKey())) {
            return this.dateTimePicker.getString((Date)rs.getTimestamp(customField.getId()));
        }
        String dbValue = rs.getString(customField.getId());
        if (StringUtils.isBlank((String)dbValue)) {
            return null;
        }
        String mappedValue = ((BugzillaConfigBean)this.configBean).getValueMappingHelper().getValueMappingForImport(customField.getId(), dbValue);
        if ("---".equals(dbValue)) {
            return null;
        }
        return StringUtils.trimToNull((String)mappedValue);
    }
}

