/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.bugzilla.transformer;

import com.atlassian.jira.plugins.importer.SqlUtils;
import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.imports.bugzilla.BugzillaConfigBean;
import com.atlassian.jira.plugins.importer.imports.bugzilla.transformer.AttachmentTransformerForAttachDataAndBigFiles;
import com.atlassian.jira.plugins.importer.imports.bugzilla.transformer.AttachmentTransformerForDataInAttachments;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.importer.ResultSetTransformer;
import com.atlassian.jira.plugins.importer.web.JdbcConnection;
import com.atlassian.jira.plugins.importer.web.SiteConfiguration;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class AttachmentTransformerFactory {
    private static final Logger log = Logger.getLogger(AttachmentTransformerFactory.class);
    private static final String META_COLUMN_NAME = "COLUMN_NAME";
    private static final String TABLE_NAME = "attachments";
    private static final String OLD_COLUMN_NAME = "thedata";
    final boolean hasOldColumnName;

    public AttachmentTransformerFactory(JdbcConnection jdbcConnection) {
        this.hasOldColumnName = this.checkForOldColumnName(jdbcConnection);
    }

    public ResultSetTransformer<ExternalAttachment> create(BugzillaConfigBean configBean, String externalIssueOldId, SiteConfiguration bugzillaUrl, ImportLogger log) {
        if (this.hasOldColumnName) {
            return new AttachmentTransformerForDataInAttachments(externalIssueOldId, configBean, log);
        }
        return new AttachmentTransformerForAttachDataAndBigFiles(externalIssueOldId, configBean, bugzillaUrl, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForOldColumnName(JdbcConnection jdbcConnection) {
        Connection connection = null;
        try {
            connection = jdbcConnection.getConnection();
            boolean bl = this.hasOldColumnName(connection);
            return bl;
        }
        catch (SQLException e) {
            log.info((Object)"Assuming Bugzilla has attachments table with thedata column and doesn't support Big Files");
            log.warn((Object)"Error getting the column name data from database", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    log.warn((Object)"Error closing connection", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasOldColumnName(Connection connection) throws SQLException {
        log.debug((Object)"Getting the column names of the 'attachments' table");
        ResultSet columns = connection.getMetaData().getColumns(null, null, TABLE_NAME, null);
        try {
            while (columns.next()) {
                String columnName = columns.getString(META_COLUMN_NAME);
                if (!OLD_COLUMN_NAME.equals(columnName)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"'attachments' table contains old column 'thedata'");
                    log.debug((Object)"Assuming Bugzilla doesn't support Big Files");
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            SqlUtils.close(columns);
        }
    }
}

