/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports.bugzilla.config;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomField;
import com.atlassian.jira.plugins.importer.imports.bugzilla.BugzillaConfigBean;
import com.atlassian.jira.plugins.importer.imports.bugzilla.config.DropDownValueMapper;
import com.atlassian.jira.plugins.importer.imports.bugzilla.config.LoginNameValueMapper;
import com.atlassian.jira.plugins.importer.imports.bugzilla.config.MultipleSelectionValueMapper;
import com.atlassian.jira.plugins.importer.imports.bugzilla.config.PriorityToPriorityValueMapper;
import com.atlassian.jira.plugins.importer.imports.bugzilla.config.ResolutionValueMapper;
import com.atlassian.jira.plugins.importer.imports.bugzilla.config.SeverityToPriorityValueMapper;
import com.atlassian.jira.plugins.importer.imports.bugzilla.config.StatusValueMapper;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingDefinition;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingDefinitionsFactory;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingHelper;
import com.atlassian.jira.plugins.importer.web.JdbcConnection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class BugzillaValueMappingDefinitionsFactory
implements ValueMappingDefinitionsFactory {
    private final JiraAuthenticationContext authenticationContext;
    private final ConstantsManager constantsManager;
    private final BugzillaConfigBean configBean;
    private final FieldManager fieldManager;

    public BugzillaValueMappingDefinitionsFactory(JiraAuthenticationContext authenticationContext, ConstantsManager constantsManager, BugzillaConfigBean configBean, FieldManager fieldManager) {
        this.authenticationContext = authenticationContext;
        this.constantsManager = constantsManager;
        this.configBean = configBean;
        this.fieldManager = fieldManager;
    }

    @Override
    public List<ValueMappingDefinition> createMappingDefinitions(ValueMappingHelper valueMappingHelper) {
        JdbcConnection jdbcConnection = this.configBean.getJdbcConnection();
        ArrayList mappings = Lists.newArrayList((Object[])new ValueMappingDefinition[]{new LoginNameValueMapper(jdbcConnection, this.authenticationContext), new StatusValueMapper(jdbcConnection, this.authenticationContext, this.configBean), new ResolutionValueMapper(jdbcConnection, this.authenticationContext, this.constantsManager)});
        for (ExternalCustomField customField : this.configBean.getCustomFields()) {
            String type = customField.getTypeKey();
            if ("bug_severity".equals(customField.getId()) && this.configBean.isFieldMappedToIssueField("bug_severity")) {
                mappings.add(new SeverityToPriorityValueMapper(jdbcConnection, this.authenticationContext, this.fieldManager, customField));
                continue;
            }
            if ("priority".equals(customField.getId()) && this.configBean.isFieldMappedToIssueField("priority")) {
                mappings.add(new PriorityToPriorityValueMapper(this.configBean, this.authenticationContext, this.fieldManager, customField));
                continue;
            }
            if ("com.atlassian.jira.plugin.system.customfieldtypes:multiselect".equals(type)) {
                mappings.add(new MultipleSelectionValueMapper(jdbcConnection, this.authenticationContext, customField));
            }
            if (!"com.atlassian.jira.plugin.system.customfieldtypes:select".equals(type)) continue;
            mappings.add(new DropDownValueMapper(this.configBean, this.authenticationContext, customField));
        }
        return mappings;
    }
}

