/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports;

import com.atlassian.jira.issue.TemporaryAttachmentsMonitorLocator;
import com.atlassian.jira.issue.attachment.TemporaryAttachment;
import com.atlassian.jira.plugins.importer.AttachmentHelper;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.json.JSONEscaper;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.util.AttachmentException;
import com.atlassian.jira.web.util.WebAttachmentManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import webwork.action.ServletActionContext;
import webwork.multipart.MultiPartRequestWrapper;

public class JIMAttachTemporaryFile
extends JiraWebActionSupport {
    private final AttachmentHelper attachmentHelper;
    private TemporaryAttachment temporaryAttachment;
    private final WebAttachmentManager webAttachmentManager;
    private final TemporaryAttachmentsMonitorLocator locator;

    public JIMAttachTemporaryFile(AttachmentHelper attachmentHelper, @ComponentImport WebAttachmentManager webAttachmentManager, @ComponentImport TemporaryAttachmentsMonitorLocator locator) {
        this.attachmentHelper = attachmentHelper;
        this.webAttachmentManager = webAttachmentManager;
        this.locator = locator;
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.getMultipart() == null) {
            this.addErrorMessage(this.getText("jira-importer-plugin.csv.setup.page.file.is.empty"));
        } else {
            try {
                this.temporaryAttachment = this.getTemporaryAttachment(this.webAttachmentManager, this.locator, this.getMultipart());
            }
            catch (AttachmentException e) {
                this.addErrorMessage(e.getMessage());
            }
            catch (IOException e) {
                this.addErrorMessage(e.getMessage());
            }
        }
        return "temp_file_json";
    }

    TemporaryAttachment getTemporaryAttachment(WebAttachmentManager webAttachmentManager, TemporaryAttachmentsMonitorLocator locator, MultiPartRequestWrapper multipart) throws AttachmentException, IOException {
        Enumeration fileNames = multipart.getFileNames();
        if (fileNames == null || !fileNames.hasMoreElements()) {
            throw new AttachmentException(this.getText("jira-importer-plugin.csv.setup.page.file.is.empty"));
        }
        String fileName = (String)fileNames.nextElement();
        webAttachmentManager.validateAttachmentIfExists(multipart, fileName, true);
        File temporaryFile = multipart.getFile(fileName);
        String filename = multipart.getFilesystemName(fileName);
        String contentType = multipart.getContentType(fileName);
        AttachmentHelper.UniqueFile uniqueFile = this.attachmentHelper.getTemporaryUniqueFile(filename);
        File file = uniqueFile.getFile();
        this.attachmentHelper.copyFile(file, temporaryFile);
        TemporaryAttachment temporaryAttachment = new TemporaryAttachment(Long.valueOf(uniqueFile.getId()), Long.valueOf(-1L), file, filename, contentType);
        locator.get(true).add(temporaryAttachment);
        return temporaryAttachment;
    }

    public String encode(String text) {
        return JSONEscaper.escape((String)text);
    }

    protected MultiPartRequestWrapper getMultipart() {
        return ServletActionContext.getMultiPartRequest();
    }

    public TemporaryAttachment getTemporaryAttachment() {
        return this.temporaryAttachment;
    }
}

