/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.imports;

import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.imports.AttachmentImportException;
import com.atlassian.jira.plugins.importer.imports.HttpDownloader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class AttachmentImporter {
    private final HttpDownloader downloader;
    private final JiraHome jiraHome;
    private final ExternalIssue externalIssue;

    public AttachmentImporter(JiraHome jiraHome, ExternalIssue externalIssue) {
        this(jiraHome, externalIssue, new HttpDownloader());
    }

    public AttachmentImporter(JiraHome jiraHome, ExternalIssue externalIssue, HttpDownloader httpDownloader) {
        this.jiraHome = jiraHome;
        this.externalIssue = externalIssue;
        this.downloader = httpDownloader;
    }

    public File importAttachmentFrom(ExternalAttachment attachment) throws IOException, ParseException {
        String guessedFileName;
        File file;
        URI uri;
        try {
            uri = new URI(attachment.getUri());
        }
        catch (URISyntaxException e) {
            throw new ParseException(e.getMessage(), 0);
        }
        if ("file".equals(uri.getScheme())) {
            String filePart = uri.getSchemeSpecificPart();
            File importAttachmentsDirectory = this.jiraHome.getImportAttachmentsDirectory();
            File sourceFile = new File(importAttachmentsDirectory, filePart).getCanonicalFile();
            if (!StringUtils.startsWith((String)sourceFile.getAbsolutePath(), (String)importAttachmentsDirectory.getCanonicalPath())) {
                throw new AttachmentImportException("Imported attachment file is outside of permitted base directory, skipping: " + filePart);
            }
            if (!sourceFile.exists() || !sourceFile.canRead()) {
                throw new AttachmentImportException("Attachment file not found or not readable, skipping: " + sourceFile.getAbsolutePath());
            }
            file = File.createTempFile("temporary-jira-importer-attachment-copy-", ".tmp");
            FileUtils.copyFile((File)sourceFile, (File)file);
            guessedFileName = sourceFile.getName();
        } else {
            file = this.downloader.getAttachmentFromUrl(null, this.externalIssue.getExternalId(), uri.toString());
            guessedFileName = new File(StringUtils.defaultString((String)uri.getPath())).getName();
        }
        if (StringUtils.isEmpty((String)attachment.getName())) {
            attachment.setName(guessedFileName);
        }
        return file;
    }
}

