/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.external;

import com.atlassian.core.util.HTMLUtils;
import com.atlassian.jira.plugins.importer.external.ExternalRuntimeException;
import com.atlassian.jira.util.ImportUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.StringEscapeUtils;

public class MimeUtils {
    public static String getTextDataFromMimeMessage(String s) {
        try {
            Session session = Session.getDefaultInstance((Properties)new Properties());
            ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes());
            MimeMessage message = new MimeMessage(session, (InputStream)is);
            return MimeUtils.getTextDataFromMimeMessage(message);
        }
        catch (Exception e) {
            throw new ExternalRuntimeException(e);
        }
    }

    private static String getTextDataFromMimeMessage(MimeMessage message) throws IOException, MessagingException {
        Object content = message.getContent();
        if (content instanceof Multipart) {
            return MimeUtils.getTextDataFromMultipart((Multipart)content);
        }
        return MimeUtils.getCleanedContent((Part)message);
    }

    private static String getTextDataFromMultipart(Multipart multipart) throws IOException, MessagingException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < multipart.getCount(); ++i) {
            BodyPart part = multipart.getBodyPart(i);
            if (part.getContentType().startsWith("text") && i == 0) {
                sb.append(MimeUtils.getCleanedContent((Part)part));
                continue;
            }
            if (part.getFileName() == null && part.getContent() instanceof MimeMessage) {
                sb.append(MimeUtils.getTextDataFromMimeMessage((MimeMessage)part.getContent()));
                continue;
            }
            if (!(part.getContent() instanceof Multipart)) continue;
            sb.append(MimeUtils.getTextDataFromMultipart((Multipart)part.getContent()));
        }
        return sb.toString();
    }

    private static String getCleanedContent(Part part) throws IOException, MessagingException {
        String content = part.getContent().toString();
        if (part.getContentType().startsWith("text/html")) {
            return MimeUtils.removeHtmlTags(content);
        }
        return content;
    }

    public static String removeHtmlTags(String textWithHtml) {
        String noTags = HTMLUtils.stripTags((String)textWithHtml);
        try {
            return StringEscapeUtils.unescapeHtml((String)noTags);
        }
        catch (NumberFormatException e) {
            return ImportUtils.stripHTMLStrings((String)noTags);
        }
    }
}

