/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.external;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.plugins.importer.Immutables;
import com.atlassian.jira.plugins.importer.compatibility.CompatibilityBridgeUtils;
import com.atlassian.jira.plugins.importer.external.InvalidUsernamesException;
import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.external.beans.NamedExternalObject;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.importer.impl.DefaultJiraDataImporter;
import com.atlassian.jira.plugins.importer.managers.CreateUserHandler;
import com.atlassian.jira.plugins.importer.managers.CreateUserHandlerProvider;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.ProjectRoleImpl;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExternalUserUtils {
    private static final String UNIFIED_USER_MANAGEMENT_FEATURE_FLAG = "unified.usermanagement";
    public static final String STUB_EMAIL_ADDRESS = "noreplay@example.com";
    private final GroupManager groupManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final ProjectRoleService projectRoleService;
    private final UserKeyService userKeyService;
    private final FeatureManager featureManager;
    private final UserService userService;
    private final UserManager userManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final CreateUserHandlerProvider createUserHandlerProvider;
    private final CompatibilityBridgeUtils bridgeUtils;

    @Autowired
    public ExternalUserUtils(@ComponentImport GroupManager groupManager, @ComponentImport GlobalPermissionManager globalPermissionManager, @ComponentImport ProjectRoleService projectRoleService, @ComponentImport UserKeyService userKeyService, @ComponentImport FeatureManager featureManager, @ComponentImport UserService userService, @ComponentImport UserManager userManager, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, CreateUserHandlerProvider createUserHandlerProvider, CompatibilityBridgeUtils bridgeUtils) {
        this.groupManager = groupManager;
        this.globalPermissionManager = globalPermissionManager;
        this.projectRoleService = projectRoleService;
        this.createUserHandlerProvider = createUserHandlerProvider;
        this.userKeyService = userKeyService;
        this.featureManager = featureManager;
        this.userService = userService;
        this.userManager = userManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.bridgeUtils = bridgeUtils;
    }

    public Collection<ExternalUser> prepareUsers(Set<ExternalUser> allUsers, DefaultJiraDataImporter.UserProvider userProvider, ImportLogger log) throws InvalidUsernamesException {
        Iterable<ExternalUser> filteredUsernames = this.filterUnallowedUsernames(allUsers, log);
        this.checkInvalidUsernames(filteredUsernames, userProvider, log);
        return Ordering.natural().onResultOf((Function)NamedExternalObject.NAME_FUNCTION).immutableSortedCopy(filteredUsernames);
    }

    private void checkInvalidUsernames(Iterable<ExternalUser> filteredUsernames, final DefaultJiraDataImporter.UserProvider userProvider, ImportLogger log) throws InvalidUsernamesException {
        Iterable nonExistingUsers = Iterables.filter(filteredUsernames, (Predicate)new Predicate<ExternalUser>(){

            public boolean apply(ExternalUser input) {
                return userProvider.getUser(input) == null;
            }
        });
        int invalidUsersCount = 0;
        for (ExternalUser nonExistingUser : nonExistingUsers) {
            nonExistingUser.setName(nonExistingUser.getName().replaceAll("[\n\r]", ""));
            UserService.CreateUsernameValidationResult validationResult = this.bridgeUtils.validateCreateUsername(this.userService, this.jiraAuthenticationContext.getUser(), nonExistingUser.getName());
            if (validationResult.isValid()) continue;
            String errors = Joiner.on((String)", ").join(validationResult.getErrorCollection().getErrors().values());
            log.warn("Invalid username '%s' - %s", nonExistingUser.getName(), errors);
            ++invalidUsersCount;
        }
        if (invalidUsersCount > 0) {
            throw new InvalidUsernamesException("Cannot perform import due to " + invalidUsersCount + " invalid usernames");
        }
    }

    public CreatedUserStatus importUser(ExternalUser externalUser, ImportLogger log) throws Exception {
        CreatedUserStatus resultStatus;
        if (StringUtils.isBlank((String)externalUser.getEmail())) {
            externalUser.setEmail(STUB_EMAIL_ADDRESS);
        } else if (!TextUtils.verifyEmail((String)externalUser.getEmail())) {
            log.warn(String.format("User %s has an invalid e-mail address [%s], creating user with e-mail %s", externalUser.getName(), externalUser.getEmail(), STUB_EMAIL_ADDRESS), new Object[0]);
            externalUser.setEmail(STUB_EMAIL_ADDRESS);
        }
        if (StringUtils.isEmpty((String)externalUser.getFullname())) {
            externalUser.setFullname(externalUser.getName());
        }
        if (this.isOnDemandWithoutUnifiedUserManagement()) {
            resultStatus = this.importUserInODWithoutUnifiedUserManagement(externalUser, log);
        } else {
            boolean isOverLicense = !this.bridgeUtils.hasSeatsAvailableInLicense(1);
            ApplicationUser user = this.bridgeUtils.createUserNoNotification(externalUser.getName(), externalUser.getPassword(), externalUser.getEmail(), externalUser.getFullname());
            this.fillUserGroups(log, user, externalUser.getGroups(), isOverLicense);
            if (!externalUser.isActive()) {
                log.log("Imported user %s (%s) as an inactive user because it was inactive in the external system", externalUser.getFullname(), externalUser.getName());
                resultStatus = CreatedUserStatus.InactiveInExternalSystem;
                this.removeUserUsePermission(user, log);
            } else if (this.bridgeUtils.rolesEnabled()) {
                log.log("Imported user %s (%s) as an inactive", externalUser.getFullname(), externalUser.getName());
                resultStatus = CreatedUserStatus.InactiveDueToLicenseRolesEnabled;
                this.removeUserUsePermission(user, log);
            } else if (isOverLicense) {
                log.log("Imported user %s (%s) as an inactive user due to license limits", externalUser.getFullname(), externalUser.getName());
                resultStatus = CreatedUserStatus.InactiveDueToLicenseLimit;
                this.removeUserUsePermission(user, log);
            } else {
                log.log("Imported user %s (%s)", externalUser.getFullname(), externalUser.getName());
                resultStatus = CreatedUserStatus.Active;
            }
        }
        return resultStatus;
    }

    private boolean isOnDemandWithoutUnifiedUserManagement() {
        return this.featureManager.isOnDemand() && !this.featureManager.getDarkFeatures().getGlobalEnabledFeatureKeys().contains(UNIFIED_USER_MANAGEMENT_FEATURE_FLAG);
    }

    private CreatedUserStatus importUserInODWithoutUnifiedUserManagement(ExternalUser externalUser, ImportLogger log) throws Exception {
        CreatedUserStatus createdUserStatus;
        CreateUserHandler handler = this.getHandler();
        boolean isOverLicense = handler.getRemainingLicenseLimit() == 0;
        ApplicationUser user = this.bridgeUtils.createUserNoNotification(externalUser.getName(), externalUser.getPassword(), externalUser.getEmail(), externalUser.getFullname());
        this.fillUserGroups(log, user, externalUser.getGroups(), false);
        if (!externalUser.isActive()) {
            log.log("Imported user %s (%s) will not be granted with access to JIRA because it was inactive in the external system", externalUser.getFullname(), externalUser.getName());
            handler.setUserJiraAccess(user.getName(), false, log);
            createdUserStatus = CreatedUserStatus.InactiveInExternalSystem;
        } else if (isOverLicense) {
            log.log("Imported user %s (%s) will not be granted with access to JIRA due to license limits.", externalUser.getFullname(), externalUser.getName());
            handler.setUserJiraAccess(user.getName(), false, log);
            createdUserStatus = CreatedUserStatus.InactiveDueToLicenseLimit;
        } else {
            log.log("Imported user %s (%s)", externalUser.getFullname(), externalUser.getName());
            handler.setUserJiraAccess(user.getName(), true, log);
            createdUserStatus = CreatedUserStatus.Active;
        }
        return createdUserStatus;
    }

    private CreateUserHandler getHandler() {
        CreateUserHandler handler = this.createUserHandlerProvider.getHandler();
        return (CreateUserHandler)Preconditions.checkNotNull((Object)handler, (Object)"Cannot find CreateUserHandler!");
    }

    private Iterable<ExternalUser> filterUnallowedUsernames(Iterable<ExternalUser> externalUsers, final ImportLogger log) {
        return Iterables.filter(externalUsers, (Predicate)new Predicate<ExternalUser>(){

            public boolean apply(@Nullable ExternalUser input) {
                boolean invalidName;
                String username = input != null ? input.getName() : "";
                boolean bl = invalidName = "Unassigned".equalsIgnoreCase(username) || ExternalUserUtils.this.jiraAuthenticationContext.getI18nHelper().getText("assignee.types.unassigned").equalsIgnoreCase(username);
                if (invalidName) {
                    log.log("Cannot import user '%s' - this name is invalid!", username);
                }
                return !invalidName;
            }
        });
    }

    private void fillUserGroups(ImportLogger log, ApplicationUser user, Set<String> groups, boolean isUserOverLicense) throws Exception {
        ArrayList<String> addedGroups = new ArrayList<String>(groups.size());
        ArrayList<String> skippedGroups = new ArrayList<String>(2);
        ArrayList<String> skippedGroupsDueToLicenseLimit = new ArrayList<String>();
        ImmutableList groupsWithSysadminPermission = this.featureManager.isOnDemand() ? this.globalPermissionManager.getGroupsWithPermission(44) : ImmutableList.of();
        Collection<Group> groupsIllegalOverLicenseLimit = this.bridgeUtils.getGroupsThatConsumesLicense();
        for (String groupName : groups) {
            Group group = this.groupManager.groupExists(groupName) ? this.groupManager.getGroupObject(groupName) : this.groupManager.createGroup(groupName);
            if (isUserOverLicense && groupsIllegalOverLicenseLimit.contains(group)) {
                skippedGroupsDueToLicenseLimit.add(groupName);
                continue;
            }
            boolean added = this.addUserToNonSysadminGroup(user, group, (Collection<Group>)groupsWithSysadminPermission);
            if (!added) {
                skippedGroups.add(groupName);
                continue;
            }
            addedGroups.add(groupName);
        }
        if (!skippedGroups.isEmpty()) {
            for (String groupName : skippedGroups) {
                log.warn("User: %s - was not added to group %s due to permission controls.", user.getName(), groupName);
            }
        }
        if (!skippedGroupsDueToLicenseLimit.isEmpty()) {
            log.log("User: %s was not added to groups [ %s ] due to license limit", user.getName(), Joiner.on((String)", ").join(skippedGroupsDueToLicenseLimit));
        }
        if (!addedGroups.isEmpty()) {
            log.log("User: %s added to %d groups: %s", user.getName(), addedGroups.size(), Joiner.on((String)", ").join(addedGroups));
        }
    }

    private boolean addUserToNonSysadminGroup(ApplicationUser user, Group group, Collection<Group> groupsWithSysadminPermission) throws Exception {
        if (this.featureManager.isOnDemand()) {
            for (Group permissionedGroups : groupsWithSysadminPermission) {
                if (!permissionedGroups.getName().equals(group.getName())) continue;
                return false;
            }
            if ("system-administrators".equals(group.getName()) || "confluence-administrators".equals(group.getName())) {
                return false;
            }
        }
        this.bridgeUtils.addUserToGroup(user, group);
        return true;
    }

    public void deactivateUser(ApplicationUser user, ImportLogger log) {
        if (this.featureManager.isOnDemand()) {
            return;
        }
        ApplicationUser deactivatedUser = ApplicationUsers.from((User)ImmutableUser.newUser((User)user.getDirectoryUser()).active(false).toUser());
        UserService.UpdateUserValidationResult updateUserValidationResult = this.userService.validateUpdateUser(deactivatedUser);
        if (!updateUserValidationResult.isValid()) {
            String errors = Joiner.on((char)'\n').join(updateUserValidationResult.getErrorCollection().getErrors().values());
            log.warn("Cannot deactivate user: %s (%s) due to: %s", user.getDisplayName(), user.getName(), errors);
            return;
        }
        this.userService.updateUser(updateUserValidationResult);
        this.restoreUserToUseGroup(user, log);
    }

    private void restoreUserToUseGroup(ApplicationUser user, ImportLogger log) {
        if (this.bridgeUtils.hasSeatsAvailableInLicense(1)) {
            try {
                this.bridgeUtils.addUserToDefaultGroups(user);
            }
            catch (Exception e) {
                log.warn(e, "Deactivated user '%s' cannot be added to jira-users group", new Object[0]);
            }
        }
    }

    private void removeUserUsePermission(ApplicationUser user, ImportLogger log) {
        try {
            this.bridgeUtils.removeUserFromGroups(this.bridgeUtils.getGroupsThatConsumesLicense(), user);
        }
        catch (PermissionException e) {
            log.fail(e, "Cannot remove 'USE' permissions for user %s (%s)", user.getName(), user.getDisplayName());
        }
        catch (RemoveException e) {
            log.fail(e, "Cannot remove 'USE' permissions for user %s (%s)", user.getName(), user.getDisplayName());
        }
    }

    public void addUsersToProjectRole(ApplicationUser user, Project jiraProject, String roleName, Collection<String> leadNames, ImportLogger log) throws Exception {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ProjectRole developersRole = this.projectRoleService.getProjectRoleByName(roleName, (ErrorCollection)errorCollection);
        if (!errorCollection.hasAnyErrors()) {
            if (developersRole == null) {
                developersRole = this.projectRoleService.createProjectRole((ProjectRole)new ProjectRoleImpl(roleName, null), (ErrorCollection)errorCollection);
            }
            if (developersRole != null && !errorCollection.hasAnyErrors()) {
                ProjectRoleActors actors = this.projectRoleService.getProjectRoleActors(developersRole, jiraProject, (ErrorCollection)errorCollection);
                if (!errorCollection.hasAnyErrors() && actors != null) {
                    ImmutableList<String> usersInRole = Immutables.transformThenCopyToList(actors.getApplicationUsers(), new Function<ApplicationUser, String>(){

                        public String apply(@Nullable ApplicationUser input) {
                            return input.getName();
                        }
                    });
                    HashSet userNamesToAdd = Sets.newHashSet(leadNames);
                    Set<String> inactiveUsers = this.getInactiveUsers(leadNames);
                    if (inactiveUsers.size() > 0) {
                        this.logInactiveUsersInformation(inactiveUsers, roleName, jiraProject.getName(), log);
                        userNamesToAdd.removeAll(inactiveUsers);
                    }
                    userNamesToAdd.removeAll((Collection<?>)usersInRole);
                    HashSet<String> userKeysToAdd = new HashSet<String>();
                    for (String username : userNamesToAdd) {
                        String userKey = this.userKeyService.getKeyForUsername(username);
                        if ("".equals(userKey) || userKey == null) continue;
                        userKeysToAdd.add(userKey);
                    }
                    if (!userKeysToAdd.isEmpty()) {
                        this.projectRoleService.addActorsToProjectRole(userKeysToAdd, developersRole, jiraProject, "atlassian-user-role-actor", (ErrorCollection)errorCollection);
                        if (!errorCollection.hasAnyErrors()) {
                            return;
                        }
                    } else {
                        return;
                    }
                }
            }
        }
        throw new Exception(String.format("Failed to add users to '%s' role for the project '%s': %s", roleName, jiraProject.getKey(), errorCollection.toString()));
    }

    private void logInactiveUsersInformation(Set<String> inactiveUsers, String roleName, String projectName, ImportLogger log) {
        String users = Joiner.on((String)", ").join(inactiveUsers);
        log.log("Cannot add inactive User(s): %s to role '%s' in project '%s'", users, roleName, projectName);
    }

    private Set<String> getInactiveUsers(Iterable<String> usernames) {
        Iterable applicationUsers = Iterables.transform(usernames, (Function)new Function<String, ApplicationUser>(){

            public ApplicationUser apply(String input) {
                return ExternalUserUtils.this.userManager.getUserByName(input);
            }
        });
        Iterable inactiveUsers = Iterables.filter((Iterable)applicationUsers, (Predicate)Predicates.and((Predicate)Predicates.notNull(), (Predicate)new Predicate<ApplicationUser>(){

            public boolean apply(ApplicationUser input) {
                return !input.isActive();
            }
        }));
        return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)inactiveUsers, (Function)new Function<ApplicationUser, String>(){

            public String apply(ApplicationUser input) {
                return input.getName();
            }
        }));
    }

    public static enum CreatedUserStatus {
        Active,
        InactiveDueToLicenseLimit,
        InactiveInExternalSystem,
        InactiveDueToLicenseRolesEnabled;

    }
}

