/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.exports.transform;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.plugins.importer.compatibility.CompatibilityBridgeUtils;
import com.atlassian.jira.plugins.importer.exports.transform.ProjectTransformer;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComponent;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.external.beans.ExternalVersion;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="default-project")
public class DefaultProjectTransformer
implements ProjectTransformer {
    private final CompatibilityBridgeUtils bridgeUtils;
    private final UserKeyService userKeyService;

    @Autowired
    public DefaultProjectTransformer(CompatibilityBridgeUtils bridgeUtils, @ComponentImport UserKeyService userKeyService) {
        this.bridgeUtils = bridgeUtils;
        this.userKeyService = userKeyService;
    }

    public ExternalProject apply(Project project) {
        ExternalProject externalProject = new ExternalProject(project.getName(), project.getKey(), project.getLeadUserName());
        externalProject.setType(this.bridgeUtils.getProjectTypeKey(project));
        externalProject.setAssigneeType(project.getAssigneeType());
        externalProject.setDescription(project.getDescription());
        if (project.getProjectComponents() != null) {
            externalProject.setComponents((Collection<ExternalComponent>)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)project.getProjectComponents(), (Function)new ComponentTransformer())));
        }
        if (project.getProjectCategoryObject() != null) {
            externalProject.setProjectCategoryName(project.getProjectCategoryObject().getName());
        }
        if (project.getVersions() != null) {
            externalProject.setVersions((Collection<ExternalVersion>)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)project.getVersions(), (Function)new VersionTransformer())));
        }
        return externalProject;
    }

    @Override
    public Set<String> getRequiredUsers(ExternalProject project) {
        HashSet users = Sets.newHashSet();
        users.add(project.getLead());
        users.addAll(ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform(project.getComponents(), (Function)new Function<ExternalComponent, String>(){

            public String apply(ExternalComponent input) {
                return input.getLead();
            }
        }), (Predicate)Predicates.notNull())));
        return users;
    }

    private class VersionTransformer
    implements Function<Version, ExternalVersion> {
        private VersionTransformer() {
        }

        public ExternalVersion apply(Version input) {
            ExternalVersion externalVersion = new ExternalVersion();
            externalVersion.setDescription(input.getDescription());
            externalVersion.setReleased(input.isReleased());
            externalVersion.setReleaseDate(input.getReleaseDate());
            externalVersion.setArchived(input.isArchived());
            externalVersion.setName(input.getName());
            return externalVersion;
        }
    }

    private class ComponentTransformer
    implements Function<ProjectComponent, ExternalComponent> {
        private ComponentTransformer() {
        }

        public ExternalComponent apply(ProjectComponent input) {
            return new ExternalComponent(input.getName(), null, DefaultProjectTransformer.this.userKeyService.getUsernameForKey(input.getLead()), input.getDescription());
        }
    }
}

