/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.exports.transform;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.vote.VoteManager;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.plugins.importer.compatibility.CompatibilityBridgeUtils;
import com.atlassian.jira.plugins.importer.exports.transform.IssueTransformer;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomFieldValue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalHistoryGroup;
import com.atlassian.jira.plugins.importer.external.beans.ExternalHistoryItem;
import com.atlassian.jira.plugins.importer.external.beans.ExternalHistoryItemBuilder;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.imports.importer.impl.customfields.CustomFieldValueFactory;
import com.atlassian.jira.project.ProjectConstant;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="default-issue")
public class DefaultIssueTransformer
implements IssueTransformer {
    private final CompatibilityBridgeUtils bridgeUtils;
    private final CustomFieldValueFactory valueFactory;
    private final VoteManager voteManager;
    private final CommentManager commentManager;
    private final WatcherManager watcherManager;
    private final ChangeHistoryManager changeHistoryManager;
    private final JiraAuthenticationContext authenticationContext;
    private final UserKeyService userKeyService;
    private final CustomFieldManager customFieldManager;

    @Autowired
    public DefaultIssueTransformer(CompatibilityBridgeUtils bridgeUtils, CustomFieldValueFactory valueFactory, @ComponentImport VoteManager voteManager, @ComponentImport CommentManager commentManager, @ComponentImport WatcherManager watcherManager, @ComponentImport ChangeHistoryManager changeHistoryManager, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport UserKeyService userKeyService, @ComponentImport CustomFieldManager customFieldManager) {
        this.bridgeUtils = bridgeUtils;
        this.valueFactory = valueFactory;
        this.voteManager = voteManager;
        this.commentManager = commentManager;
        this.watcherManager = watcherManager;
        this.changeHistoryManager = changeHistoryManager;
        this.authenticationContext = authenticationContext;
        this.userKeyService = userKeyService;
        this.customFieldManager = customFieldManager;
    }

    public ExternalIssue apply(Issue issue) {
        List<ChangeHistory> changeHistories;
        Collection voters;
        List watchers;
        List comments;
        ApplicationUser reporter;
        ExternalIssue ei = new ExternalIssue();
        ei.setKey(issue.getKey());
        ei.setSummary(issue.getSummary());
        ei.setCreated(issue.getCreated());
        ei.setUpdated(issue.getUpdated());
        ei.setDuedate(issue.getDueDate());
        ei.setResolutionDate(issue.getResolutionDate());
        ei.setDescription(issue.getDescription());
        ei.setEnvironment(issue.getEnvironment());
        ei.setTimeSpent(issue.getTimeSpent());
        ei.setEstimate(issue.getEstimate());
        ei.setOriginalEstimate(issue.getOriginalEstimate());
        ei.setIssueType(this.safeGetName((IssueConstant)issue.getIssueTypeObject()));
        ei.setStatus(this.safeGetName((IssueConstant)issue.getStatusObject()));
        ei.setPriority(this.safeGetName((IssueConstant)issue.getPriorityObject()));
        ei.setResolution(this.safeGetName((IssueConstant)issue.getResolutionObject()));
        ei.setComponents(this.safeGetNames(issue.getComponentObjects()));
        ei.setAffectedVersions(this.safeGetNames(issue.getAffectedVersions()));
        ei.setFixedVersions(this.safeGetNames(issue.getFixVersions()));
        ApplicationUser assignee = this.bridgeUtils.getAssignee(issue);
        if (assignee != null) {
            ei.setAssignee(assignee.getName());
        }
        if ((reporter = this.bridgeUtils.getReporter(issue)) != null) {
            ei.setReporter(reporter.getName());
        }
        if (issue.getLabels() != null) {
            ei.setLabels(Collections2.transform((Collection)issue.getLabels(), (Function)new Function<Label, String>(){

                public String apply(Label input) {
                    return input.getLabel();
                }
            }));
        }
        if ((comments = this.commentManager.getComments(issue)) != null) {
            ei.setComments(Collections2.transform((Collection)comments, (Function)new Function<Comment, ExternalComment>(){

                public ExternalComment apply(Comment input) {
                    ApplicationUser author = input.getAuthorApplicationUser();
                    return new ExternalComment(input.getBody(), author != null ? author.getName() : null, input.getCreated());
                }
            }));
        }
        if ((watchers = this.watcherManager.getCurrentWatcherUsernames(issue)) != null) {
            ei.setWatchers(watchers);
        }
        if ((voters = this.voteManager.getVoterUserkeys(issue)) != null) {
            ei.setVoters(Collections2.transform((Collection)voters, (Function)new Function<String, String>(){

                public String apply(String input) {
                    return DefaultIssueTransformer.this.userKeyService.getUsernameForKey(input);
                }
            }));
        }
        if ((changeHistories = this.bridgeUtils.getChangeHistoriesForUser(this.changeHistoryManager, issue, this.authenticationContext.getUser())) != null) {
            Iterable transformedHistory = Iterables.transform(changeHistories, (Function)new ChangeHistoryFunction());
            ei.setHistory(Lists.newArrayList((Iterable)transformedHistory));
        }
        ei.setExternalCustomFieldValues(this.extractCustomFields(issue));
        return ei;
    }

    private List<ExternalCustomFieldValue> extractCustomFields(final Issue issue) {
        List customFields = this.customFieldManager.getCustomFieldObjects(issue);
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)customFields, (Function)new Function<CustomField, ExternalCustomFieldValue>(){

            public ExternalCustomFieldValue apply(CustomField input) {
                Optional<Object> valueForExport = DefaultIssueTransformer.this.valueFactory.prepareValueForExport(input, issue);
                if (valueForExport.isPresent()) {
                    CustomFieldSearcher searcher = input.getCustomFieldSearcher();
                    String cfName = input.getName();
                    String cfType = input.getCustomFieldType().getDescriptor().getCompleteKey();
                    String cfSearcher = searcher != null ? searcher.getDescriptor().getCompleteKey() : null;
                    return new ExternalCustomFieldValue(cfName, cfType, cfSearcher, valueForExport.get());
                }
                return null;
            }
        }), (Predicate)Predicates.notNull()));
    }

    @Override
    public Set<String> getRequiredUsers(ExternalIssue issue) {
        HashSet users = Sets.newHashSet();
        users.add(issue.getAssignee());
        users.add(issue.getReporter());
        users.addAll(issue.getWatchers());
        users.addAll(issue.getVoters());
        users.addAll(ImmutableSet.copyOf((Iterable)Iterables.transform(issue.getComments(), (Function)new Function<ExternalComment, String>(){

            public String apply(ExternalComment input) {
                return input.getAuthor();
            }
        })));
        users.addAll(ImmutableSet.copyOf((Iterable)Iterables.transform(issue.getHistory(), (Function)new Function<ExternalHistoryGroup, String>(){

            public String apply(ExternalHistoryGroup input) {
                return input.getAuthor();
            }
        })));
        return users;
    }

    private Collection<String> safeGetNames(Collection<? extends ProjectConstant> inputCollection) {
        if (inputCollection == null) {
            return ImmutableList.of();
        }
        return Collections2.transform(inputCollection, (Function)new NameFunction());
    }

    private String safeGetName(IssueConstant issueConstant) {
        return issueConstant != null ? issueConstant.getName() : "";
    }

    private static class HistoryItemFunction
    implements Function<ChangeItemBean, ExternalHistoryItem> {
        private HistoryItemFunction() {
        }

        public ExternalHistoryItem apply(ChangeItemBean item) {
            return new ExternalHistoryItemBuilder().setFieldType(item.getFieldType()).setField(item.getField()).setOldValue(item.getFrom()).setOldDisplayValue(item.getFromString()).setNewValue(item.getTo()).setNewDisplayValue(item.getToString()).createExternalHistoryItem();
        }
    }

    private static class ChangeHistoryFunction
    implements Function<ChangeHistory, ExternalHistoryGroup> {
        private ChangeHistoryFunction() {
        }

        public ExternalHistoryGroup apply(ChangeHistory changeHistory) {
            String author = changeHistory.getAuthorObject() != null ? changeHistory.getAuthorObject().getName() : "";
            DateTime date = changeHistory.getTimePerformed() != null ? new DateTime((Object)changeHistory.getTimePerformed()) : null;
            ArrayList historyItems = Lists.newArrayList((Iterable)Iterables.transform((Iterable)changeHistory.getChangeItemBeans(), (Function)new HistoryItemFunction()));
            return new ExternalHistoryGroup(author, date, historyItems);
        }
    }

    private static class NameFunction
    implements Function<ProjectConstant, String> {
        private NameFunction() {
        }

        public String apply(ProjectConstant input) {
            return input.getName();
        }
    }
}

