/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.demo;

import com.atlassian.jira.plugins.importer.exports.transform.DefaultUserTransformer;
import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="demo-user")
public class DemoUserTransformer
extends DefaultUserTransformer {
    private final JiraAuthenticationContext authenticationContext;

    @Autowired
    public DemoUserTransformer(@ComponentImport UserUtil userUtil, @ComponentImport JiraAuthenticationContext authenticationContext) {
        super(userUtil);
        this.authenticationContext = authenticationContext;
    }

    @Override
    public ExternalUser apply(String username) {
        if (this.authenticationContext.getUser().getName().equals(username)) {
            return null;
        }
        ExternalUser user = super.apply(username);
        if (user != null) {
            user.setGroups((Set<String>)ImmutableSet.of());
        }
        return user;
    }
}

