/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.demo;

import com.atlassian.jira.plugins.importer.compatibility.CompatibilityBridgeUtils;
import com.atlassian.jira.plugins.importer.demo.DemoDataConstants;
import com.atlassian.jira.plugins.importer.exports.transform.DefaultProjectTransformer;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComponent;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="demo-project")
public class DemoProjectTransformer
extends DefaultProjectTransformer {
    private final JiraAuthenticationContext authenticationContext;

    @Autowired
    public DemoProjectTransformer(CompatibilityBridgeUtils bridgeUtils, @ComponentImport UserKeyService userKeyService, @ComponentImport JiraAuthenticationContext authenticationContext) {
        super(bridgeUtils, userKeyService);
        this.authenticationContext = authenticationContext;
    }

    @Override
    public ExternalProject apply(Project project) {
        ExternalProject externalProject = super.apply(project);
        externalProject.setExternalName(null);
        externalProject.setKey(DemoDataConstants.wrapAsVariable("projectKey"));
        externalProject.setName(DemoDataConstants.wrapAsVariable("projectName"));
        externalProject.setLead(DemoDataConstants.wrapAsVariable("projectLead"));
        externalProject.setTemplate(DemoDataConstants.wrapAsVariable("projectTemplate"));
        externalProject.setAssigneeType(null);
        if (externalProject.getComponents() != null) {
            final String currentUser = this.authenticationContext.getUser().getName();
            externalProject.setComponents((Collection<ExternalComponent>)ImmutableList.copyOf((Iterable)Iterables.transform(externalProject.getComponents(), (Function)new Function<ExternalComponent, ExternalComponent>(){

                public ExternalComponent apply(ExternalComponent input) {
                    if (currentUser.equals(input.getLead())) {
                        return new ExternalComponent(input.getName(), input.getId(), DemoDataConstants.wrapAsVariable("currentUser"), input.getDescription());
                    }
                    return input;
                }
            })));
        }
        return externalProject;
    }
}

