/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.demo;

import com.atlassian.jira.bc.issue.properties.IssuePropertyService;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.vote.VoteManager;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.plugins.importer.compatibility.CompatibilityBridgeUtils;
import com.atlassian.jira.plugins.importer.demo.DemoDataConstants;
import com.atlassian.jira.plugins.importer.exports.transform.DefaultIssueTransformer;
import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalHistoryGroup;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.imports.importer.impl.customfields.CustomFieldValueFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.util.io.InputStreamConsumer;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="demo-issue")
public class DemoIssueTransformer
extends DefaultIssueTransformer {
    private static final Logger log = LoggerFactory.getLogger(DemoIssueTransformer.class);
    private final AttachmentManager attachmentManager;
    private final JiraAuthenticationContext authenticationContext;
    private final IssuePropertyService issuePropertyService;

    @Autowired
    public DemoIssueTransformer(CompatibilityBridgeUtils bridgeUtils, CustomFieldValueFactory valueFactory, @ComponentImport VoteManager voteManager, @ComponentImport CommentManager commentManager, @ComponentImport WatcherManager watcherManager, @ComponentImport ChangeHistoryManager changeHistoryManager, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport UserKeyService userKeyService, @ComponentImport CustomFieldManager customFieldManager, @ComponentImport AttachmentManager attachmentManager, @ComponentImport IssuePropertyService issuePropertyService) {
        super(bridgeUtils, valueFactory, voteManager, commentManager, watcherManager, changeHistoryManager, authenticationContext, userKeyService, customFieldManager);
        this.attachmentManager = attachmentManager;
        this.authenticationContext = authenticationContext;
        this.issuePropertyService = issuePropertyService;
    }

    @Override
    public ExternalIssue apply(final Issue issue) {
        ExternalIssue externalIssue = super.apply(issue);
        externalIssue.setKey(null);
        externalIssue.setReporter(this.filerOutCurrentUser(externalIssue.getReporter()));
        externalIssue.setAssignee(this.filerOutCurrentUser(externalIssue.getAssignee()));
        externalIssue.setHistory((List<ExternalHistoryGroup>)ImmutableList.of());
        List attachments = this.attachmentManager.getAttachments(issue);
        externalIssue.setAttachments((List<ExternalAttachment>)ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)attachments, (Function)new Function<Attachment, ExternalAttachment>(){

            public ExternalAttachment apply(Attachment input) {
                try {
                    Attachment attachment = DemoIssueTransformer.this.attachmentManager.getAttachment(input.getId());
                    String base64 = (String)DemoIssueTransformer.this.attachmentManager.streamAttachmentContent(attachment, (InputStreamConsumer)new InputStreamConsumer<String>(){

                        public String withInputStream(InputStream inputStream) throws IOException {
                            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
                            return new String(Base64.encodeBase64((byte[])bytes));
                        }
                    });
                    return new ExternalAttachment(input.getFilename(), null, new DateTime((Object)input.getCreated()), DemoIssueTransformer.this.filerOutCurrentUser(input.getAuthorObject().getName()), base64);
                }
                catch (IOException e) {
                    log.warn("Cannot export attachment for issue: " + issue.getKey(), (Throwable)e);
                    return null;
                }
            }
        }), (Predicate)Predicates.notNull())));
        ApplicationUser currentUser = this.authenticationContext.getUser();
        EntityPropertyService.PropertyKeys propertyKeys = this.issuePropertyService.getPropertiesKeys(currentUser, issue.getId());
        List keys = propertyKeys.getKeys();
        for (String key : keys) {
            EntityPropertyService.PropertyResult property = this.issuePropertyService.getProperty(currentUser, issue.getId(), key);
            if (!property.isValid() || !property.getEntityProperty().isDefined()) continue;
            EntityProperty entityProperty = (EntityProperty)property.getEntityProperty().get();
            externalIssue.addProperty(key, entityProperty.getValue());
        }
        return externalIssue;
    }

    private String filerOutCurrentUser(String username) {
        String currentUserName = this.authenticationContext.getUser().getName();
        if (currentUserName.equals(username)) {
            return DemoDataConstants.wrapAsVariable("currentUser");
        }
        return username;
    }
}

