/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.demo;

import com.atlassian.jira.config.PriorityManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.plugins.importer.appbridge.software.JimJiraSoftwareAccessor;
import com.atlassian.jira.plugins.importer.demo.DemoDataProjectInfoBean;
import com.atlassian.jira.plugins.importer.demo.DemoJSONEscaper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DemoDataProjectInfoBeanConverter {
    public static final String DEFAULT_MIDDLE_PRIORITY_NAME = "Middle";
    public static final String DEFAULT_HIGHEST_PRIORITY_NAME = "Blocker";
    public static final String DEFAULT_CUSTOM_FIELD_NAME = "Demo Data Custom Field";
    public static final String DEFAULT_LOWEST_PRIORITY_NAME = "Low";
    private final JiraAuthenticationContext authenticationContext;
    private final JiraBaseUrls baseUrl;
    private final PriorityManager priorityManager;
    private final CustomFieldManager customFieldManager;
    private final JimJiraSoftwareAccessor jimJiraSoftwareAccessor;
    private final I18nHelper.BeanFactory i18nBeanFactory;
    private final ApplicationProperties applicationProperties;

    @Autowired
    public DemoDataProjectInfoBeanConverter(@ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport JiraBaseUrls baseUrl, @ComponentImport PriorityManager priorityManager, @ComponentImport CustomFieldManager customFieldManager, @ComponentImport I18nHelper.BeanFactory i18nBeanFactory, @ComponentImport ApplicationProperties applicationProperties, JimJiraSoftwareAccessor jimJiraSoftwareAccessor) {
        this.authenticationContext = authenticationContext;
        this.baseUrl = baseUrl;
        this.priorityManager = priorityManager;
        this.customFieldManager = customFieldManager;
        this.jimJiraSoftwareAccessor = jimJiraSoftwareAccessor;
        this.i18nBeanFactory = i18nBeanFactory;
        this.applicationProperties = applicationProperties;
    }

    private String getMiddlePriorityName() {
        List<Priority> priorities = this.getOrderedPriorities();
        if (priorities.isEmpty()) {
            return DEFAULT_MIDDLE_PRIORITY_NAME;
        }
        int middleIndex = priorities.size() / 2;
        return priorities.get(middleIndex).getName();
    }

    private String getHighestPriorityName() {
        List<Priority> priorities = this.getOrderedPriorities();
        if (priorities.isEmpty()) {
            return DEFAULT_HIGHEST_PRIORITY_NAME;
        }
        return priorities.get(priorities.size() - 1).getName();
    }

    private String getLowestPriority() {
        List<Priority> priorities = this.getOrderedPriorities();
        if (priorities.isEmpty()) {
            return DEFAULT_LOWEST_PRIORITY_NAME;
        }
        return priorities.get(0).getName();
    }

    private List<Priority> getOrderedPriorities() {
        ArrayList priorities = Lists.newArrayList((Iterable)this.priorityManager.getPriorities());
        return Lists.reverse((List)priorities);
    }

    public Map<String, Object> toVelocityParameters(DemoDataProjectInfoBean bean) {
        String guessedProjectLead = bean.getProjectLead();
        if (StringUtils.isEmpty((CharSequence)guessedProjectLead)) {
            guessedProjectLead = this.authenticationContext.getUser().getName();
        }
        ImmutableMap.Builder map = ImmutableMap.builder().put((Object)"projectKey", (Object)bean.getProjectKey()).put((Object)"projectName", (Object)bean.getProjectName()).put((Object)"projectLead", (Object)guessedProjectLead).put((Object)"currentUser", (Object)this.authenticationContext.getUser().getName()).put((Object)"highestPriority", (Object)this.getHighestPriorityName()).put((Object)"middlePriority", (Object)this.getMiddlePriorityName()).put((Object)"lowestPriority", (Object)this.getLowestPriority()).put((Object)"customFields", (Object)new CustomFieldsUtil()).put((Object)"issueTypes", (Object)new IssueTypeUtil()).put((Object)"i18nDefault", (Object)this.i18nBeanFactory.getInstance(this.applicationProperties.getDefaultLocale())).put((Object)"i18nUser", (Object)this.authenticationContext.getI18nHelper()).put((Object)"contextPath", (Object)this.baseUrl.baseUrl());
        if (bean.getProjectTemplate().isDefined()) {
            map.put((Object)"projectTemplate", bean.getProjectTemplate().get());
        }
        if (bean.getProjectType().isDefined()) {
            map.put((Object)"projectType", bean.getProjectType().get());
        }
        map.put((Object)"jsEscaper", (Object)new DemoJSONEscaper());
        return map.build();
    }

    public class IssueTypeUtil {
        public String epic() {
            return DemoDataProjectInfoBeanConverter.this.jimJiraSoftwareAccessor.getEpicIssueType();
        }

        public String story() {
            return DemoDataProjectInfoBeanConverter.this.jimJiraSoftwareAccessor.getStoryIssueType();
        }
    }

    public class CustomFieldsUtil {
        public String byType(final String type) {
            CustomField matchingCf = (CustomField)Iterables.getFirst((Iterable)Iterables.filter((Iterable)DemoDataProjectInfoBeanConverter.this.customFieldManager.getCustomFieldObjects(), (Predicate)new Predicate<CustomField>(){

                public boolean apply(@Nullable CustomField customField) {
                    return type.equals(customField.getCustomFieldType().getKey());
                }
            }), null);
            return matchingCf != null ? matchingCf.getName() : DemoDataProjectInfoBeanConverter.DEFAULT_CUSTOM_FIELD_NAME;
        }

        public String storyPoints() {
            return DemoDataProjectInfoBeanConverter.this.jimJiraSoftwareAccessor.getStoryPointsCustomFieldName();
        }
    }
}

