/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.compatibility;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.issue.link.IssueLinkService;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItem;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.exception.AddException;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.plugins.importer.VersionKit;
import com.atlassian.jira.plugins.importer.compatibility.CompatibilityUtil;
import com.atlassian.jira.plugins.importer.compatibility.CompatibilityUtil70;
import com.atlassian.jira.plugins.importer.compatibility.CompatibilityUtil71;
import com.atlassian.jira.plugins.importer.compatibility.CompatibilityUtilPre70;
import com.atlassian.jira.plugins.importer.compatibility.DemoProjectsAccessor;
import com.atlassian.jira.plugins.importer.compatibility.ProjectTypeInfo;
import com.atlassian.jira.plugins.importer.compatibility.UserAccessGrantingResult;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.model.WebPanel;
import com.google.common.base.Predicate;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import org.ofbiz.core.entity.GenericValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class CompatibilityBridgeUtils {
    private static final VersionKit.SoftwareVersion JIRA_7_0 = VersionKit.version(7, 0);
    private static final VersionKit.SoftwareVersion JIRA_7_1 = VersionKit.version(7, 1);
    private final CompatibilityUtil compatibilityUtil;

    @Autowired
    public CompatibilityBridgeUtils(@ComponentImport BuildUtilsInfo buildUtilsInfo) {
        VersionKit.SoftwareVersion currentJiraVersion = VersionKit.version(buildUtilsInfo);
        this.compatibilityUtil = currentJiraVersion.isLessThan(JIRA_7_0) ? new CompatibilityUtilPre70() : (currentJiraVersion.isLessThan(JIRA_7_1) ? new CompatibilityUtil70() : new CompatibilityUtil71());
    }

    public MutableIssue createFixedKeyIssue(MutableIssue issue, String key) {
        return this.compatibilityUtil.createFixedKeyIssue(issue, key);
    }

    public void setAssignee(MutableIssue issue, ApplicationUser user) {
        this.compatibilityUtil.setAssignee(issue, user);
    }

    public void setReporter(MutableIssue issue, ApplicationUser user) {
        this.compatibilityUtil.setReporter(issue, user);
    }

    public ApplicationUser createUserNoNotification(String username, String password, String emailAddress, String displayName) throws PermissionException, CreateException {
        return this.compatibilityUtil.createUserNoNotification(username, password, emailAddress, displayName);
    }

    public void addUserToGroup(ApplicationUser user, Group group) throws AddException, PermissionException {
        this.compatibilityUtil.addUserToGroup(user, group);
    }

    public void addUserToDefaultGroups(ApplicationUser user) throws AddException, PermissionException {
        this.compatibilityUtil.addUserToDefaultGroups(user);
    }

    public void removeUserFromGroups(Collection<Group> groups, ApplicationUser user) throws RemoveException, PermissionException {
        this.compatibilityUtil.removeUserFromGroups(groups, user);
    }

    public void createWorklog(ApplicationUser user, Worklog worklog) {
        this.compatibilityUtil.createWorklog(user, worklog);
    }

    public ProjectService.CreateProjectValidationResult validateCreateProject(ApplicationUser loggedInUser, String name, String key, String description, String lead, String url, Long assigneeType, String projectType, String template) {
        return this.compatibilityUtil.validateCreateProject(loggedInUser, name, key, description, lead, url, assigneeType, projectType, template);
    }

    public Issue updateIssue(ApplicationUser user, MutableIssue issue) {
        return this.compatibilityUtil.updateIssue(user, issue);
    }

    public void setComponents(MutableIssue issue, List<ProjectComponent> components) {
        this.compatibilityUtil.setComponents(issue, components);
    }

    public IssueService.CreateValidationResult validateCreate(IssueService issueService, ApplicationUser user, IssueInputParameters issueInputParameters) {
        return this.compatibilityUtil.validateCreate(issueService, user, issueInputParameters);
    }

    public GenericValue createIssue(IssueManager issueManager, ApplicationUser user, Issue issue) throws CreateException {
        return this.compatibilityUtil.createIssue(issueManager, user, issue);
    }

    public void createSubTaskIssueLink(SubTaskManager subTaskManager, Issue destinationIssue, Issue sourceIssue, ApplicationUser user) throws CreateException {
        this.compatibilityUtil.createSubTaskIssueLink(subTaskManager, destinationIssue, sourceIssue, user);
    }

    public List<ChangeHistory> getChangeHistoriesForUser(ChangeHistoryManager changeHistoryManager, Issue issue, ApplicationUser user) {
        return this.compatibilityUtil.getChangeHistoiesForUser(changeHistoryManager, issue, user);
    }

    public UserService.CreateUsernameValidationResult validateCreateUsername(UserService userService, ApplicationUser user, String name) {
        return this.compatibilityUtil.validateCreateUsername(userService, user, name);
    }

    public boolean doesUserHavePermission(ManagedConfigurationItemService managedConfigurationItemService, ApplicationUser user, ManagedConfigurationItem item) {
        return this.compatibilityUtil.doesUserHavePermission(managedConfigurationItemService, user, item);
    }

    public IssueService.CreateValidationResult validateSubTaskCreate(IssueService issueService, ApplicationUser user, Long subtaskParentId, IssueInputParameters issueInputParameters) {
        return this.compatibilityUtil.validateSubTaskCreate(issueService, user, subtaskParentId, issueInputParameters);
    }

    public IssueService.IssueResult getIssue(IssueService issueService, ApplicationUser user, Long parentId) {
        return this.compatibilityUtil.getIssue(issueService, user, parentId);
    }

    public IssueService.IssueResult getIssue(IssueService issueService, ApplicationUser user, String key) {
        return this.compatibilityUtil.getIssue(issueService, user, key);
    }

    public IssueService.IssueResult create(IssueService issueService, ApplicationUser user, IssueService.CreateValidationResult validationResult) {
        return this.compatibilityUtil.create(issueService, user, validationResult);
    }

    public void addIssueLinks(IssueLinkService issueLinkService, ApplicationUser user, IssueLinkService.AddIssueLinkValidationResult validationResult) {
        this.compatibilityUtil.addIssueLinks(issueLinkService, user, validationResult);
    }

    public ApplicationUser getAssignee(Issue mutableIssue) {
        return this.compatibilityUtil.getAssignee(mutableIssue);
    }

    public Issue startWatching(WatcherManager watcherManager, ApplicationUser watcher, Issue issue) {
        return this.compatibilityUtil.startWatching(watcherManager, watcher, issue);
    }

    public ApplicationUser getReporter(Issue issue) {
        return this.compatibilityUtil.getReporter(issue);
    }

    public IssueLinkService.AddIssueLinkValidationResult validateAddIssueLinks(IssueLinkService issueLinkService, ApplicationUser user, Issue sourceIssue, String linkDirection, List<String> destinationIssues) {
        return this.compatibilityUtil.validateAddIssueLinks(issueLinkService, user, sourceIssue, linkDirection, destinationIssues);
    }

    public void setVersionReleasedArchivedAndStartDate(VersionManager versionManager, Version version, boolean released, boolean archived, DateTime startDate) {
        this.compatibilityUtil.setVersionReleasedArchivedAndStartDate(versionManager, version, released, archived, startDate);
    }

    public boolean hasSeatsAvailableInLicense(int numOfSeats) {
        return this.compatibilityUtil.hasSeatsAvailableInLicense(numOfSeats);
    }

    public Collection<Group> getGroupsThatConsumesLicense() {
        return this.compatibilityUtil.getGroupsThatConsumesLicense();
    }

    public <K, V> V getFromCache(Cache<K, V> cachedResults, K key) {
        return (V)this.compatibilityUtil.getFromCache(cachedResults, key);
    }

    public List<ProjectTypeInfo> getProjectTypes() {
        return this.compatibilityUtil.getProjectTypes();
    }

    public String getProjectTypeKey(Project project) {
        return this.compatibilityUtil.getProjectTypeKey(project);
    }

    public <K, V> Cache<K, V> buildCache(CacheBuilder<? super K, ? super V> cacheBuilder, CacheLoader<K, V> cacheLoader) {
        return this.compatibilityUtil.buildCache(cacheBuilder, cacheLoader);
    }

    public List<?> getPossibleApplicationSelection() {
        return this.compatibilityUtil.getPossibleApplicationSelection();
    }

    public boolean rolesEnabled() {
        return this.compatibilityUtil.rolesEnabled();
    }

    public UserAccessGrantingResult giveUserAccess(String[] selectedApplications, Set<ApplicationUser> createdUsers) {
        return this.compatibilityUtil.giveUserAccess(selectedApplications, createdUsers);
    }

    public String renderWebPanelsFor(String userAccessLocation, Map<String, Object> context) {
        return this.compatibilityUtil.renderWebPanelsFor(userAccessLocation, context);
    }

    public String renderWebPanelsFor(String userAccessLocation, Map<String, Object> context, Predicate<ModuleDescriptor<WebPanel>> predicate) {
        return this.compatibilityUtil.renderWebPanelsFor(userAccessLocation, context, predicate);
    }

    public Option<DemoProjectsAccessor> getDemoProjectsAccessor() {
        return this.compatibilityUtil.getDemoProjectsAccessor();
    }

    public boolean isProductEvaluationLicenseForProjectType(String projectType) {
        return this.compatibilityUtil.isProductEvaluationLicenseForProjectType(projectType);
    }

    public Option<Date> getUserCreatedDate(ApplicationUser applicationUser) {
        return this.compatibilityUtil.getUserCreatedDate(applicationUser);
    }

    public Option<Date> getInstanceCreatedDate() {
        return this.compatibilityUtil.getInstanceCreatedDate();
    }
}

